/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape.drag;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.shape.drag.DragShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DragShapePyramid
extends DragShape {
    public DragShapePyramid() {
        super("pyramid");
    }

    public EnumFacing getFacing(NBTTagCompound nbt) {
        if (nbt.func_74764_b("facing")) {
            return EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        }
        return EnumFacing.UP;
    }

    @Override
    public LittleBoxes getBoxes(LittleBoxes boxes, LittleVec min, LittleVec max, EntityPlayer player, NBTTagCompound nbt, boolean preview, PlacementPosition originalMin, PlacementPosition originalMax) {
        LittleBox box = new LittleBox(min, max);
        EnumFacing facing = this.getFacing(nbt);
        EnumFacing.Axis axis = facing.func_176740_k();
        boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
        int minAxis = box.getMin(axis);
        int maxAxis = box.getMax(axis);
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
        int minOne = box.getMin(one);
        int minTwo = box.getMin(two);
        int maxOne = box.getMax(one);
        int maxTwo = box.getMax(two);
        int counter = 0;
        if (positive) {
            for (int i = minAxis; i < maxAxis; ++i) {
                LittleBox toAdd = new LittleBox(i, i, i, i + 1, i + 1, i + 1);
                toAdd.setMin(one, Math.min(minOne + counter, maxOne - counter));
                toAdd.setMin(two, Math.min(minTwo + counter, maxTwo - counter));
                toAdd.setMax(one, Math.max(minOne + counter, maxOne - counter));
                toAdd.setMax(two, Math.max(minTwo + counter, maxTwo - counter));
                boxes.add(toAdd);
                ++counter;
            }
        } else {
            for (int i = maxAxis - 1; i >= minAxis; --i) {
                LittleBox toAdd = new LittleBox(i, i, i, i + 1, i + 1, i + 1);
                toAdd.setMin(one, Math.min(minOne + counter, maxOne - counter));
                toAdd.setMin(two, Math.min(minTwo + counter, maxTwo - counter));
                toAdd.setMax(one, Math.max(minOne + counter, maxOne - counter));
                toAdd.setMax(two, Math.max(minTwo + counter, maxTwo - counter));
                boxes.add(toAdd);
                ++counter;
            }
        }
        return boxes;
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        list.add("facing: " + this.getFacing(nbt).name().toLowerCase());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        String[] states = new String[6];
        for (int i = 0; i < states.length; ++i) {
            states[i] = "facing: " + EnumFacing.func_82600_a((int)i).name().toLowerCase();
        }
        controls.add((GuiControl)new GuiStateButton("direction", nbt.func_74764_b("facing") ? nbt.func_74762_e("facing") : EnumFacing.UP.ordinal(), 5, 27, states));
        return controls;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.func_74768_a("facing", state.getState());
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
        EnumFacing facing = this.getFacing(nbt);
        facing = RotationUtils.rotate((EnumFacing)facing, (Rotation)rotation);
        nbt.func_74768_a("facing", facing.ordinal());
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
        EnumFacing facing = this.getFacing(nbt);
        facing = RotationUtils.flip((EnumFacing)facing, (EnumFacing.Axis)axis);
        nbt.func_74768_a("facing", facing.ordinal());
    }
}

