/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape.select;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.shape.select.SelectShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SelectShapeConnected
extends SelectShape {
    private static final ConnectedBlock EMPTY = new ConnectedBlock(null, null);

    public SelectShapeConnected() {
        super("connected");
    }

    @Override
    public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
        return false;
    }

    @Override
    public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
        return true;
    }

    @Override
    public LittleBoxes getHighlightBoxes(World world, BlockPos pos, EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
        return this.getBoxes(world, pos, player, nbt, result, context);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        return new ArrayList<GuiControl>();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
    }

    @Override
    public LittleBoxes getBoxes(World world, BlockPos pos, EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
        LittleBoxes boxes;
        BlockTile.TEResult te = BlockTile.loadTeAndTile((IBlockAccess)world, pos, player);
        if (te.isComplete()) {
            if (te.parent.isStructure()) {
                return new LittleBoxes(te.te.func_174877_v(), te.te.getContext());
            }
            boolean secondMode = LittleAction.isUsingSecondMode(player);
            ConnectedBlock block = new ConnectedBlock(te.te, te.tile);
            boxes = block.start(te.tile);
        } else {
            boxes = new LittleBoxes(pos, context);
            boxes.add(new LittleBox(0, 0, 0, context.size, context.size, context.size));
        }
        return boxes;
    }

    @Override
    public void deselect(EntityPlayer player, NBTTagCompound nbt, LittleGridContext context) {
    }

    @Override
    public void addExtraInformation(World world, NBTTagCompound nbt, List<String> list, LittleGridContext context) {
    }

    private static class ConnectedBlock {
        private final TileEntityLittleTiles parent;
        private final List<LittleBox> potential;
        private ConnectedBlock[] neighborCache = new ConnectedBlock[6];

        public ConnectedBlock(TileEntityLittleTiles te, LittleTile startTile) {
            this.parent = te;
            this.potential = new ArrayList<LittleBox>();
            if (te != null) {
                for (LittleTile tile : te.noneStructureTiles()) {
                    if (tile == startTile || !tile.canBeCombined(startTile) || !startTile.canBeCombined(tile)) continue;
                    this.potential.add(tile.getBox());
                }
            }
        }

        public LittleBoxes start(LittleTile startTile) {
            HashMap<BlockPos, ConnectedBlock> blocks = new HashMap<BlockPos, ConnectedBlock>();
            blocks.put(this.parent.func_174877_v(), this);
            LittleBoxes boxes = new LittleBoxes(this.parent.func_174877_v(), this.parent.getContext());
            boxes.addBox(this.parent.getContext(), this.parent.func_174877_v(), startTile.getBox().copy());
            this.performSearchIn(boxes, blocks, startTile, true, this.parent.getContext(), startTile.getBox().copy());
            return boxes;
        }

        public void performSearchIn(LittleBoxes boxes, HashMap<BlockPos, ConnectedBlock> blocks, LittleTile startTile, boolean start, LittleGridContext other, LittleBox otherBox) {
            LittleGridContext context = this.parent.getContext();
            ArrayList<LittleBox> added = new ArrayList<LittleBox>();
            for (int index = 0; index <= added.size(); ++index) {
                Iterator<LittleBox> iterator = this.potential.iterator();
                while (iterator.hasNext()) {
                    LittleBox box = iterator.next();
                    if (!(index == 0 ? box.doesTouch(context, other, otherBox) : box.doesTouch((LittleBox)added.get(index - 1)))) continue;
                    LittleBox copy = box.copy();
                    boxes.addBox(this.parent.getContext(), this.parent.func_174877_v(), copy);
                    added.add(box.copy());
                    iterator.remove();
                }
            }
            if (start) {
                added.add(otherBox);
            }
            for (LittleBox box : added) {
                for (int i = 0; i < this.neighborCache.length; ++i) {
                    ConnectedBlock block;
                    EnumFacing facing = EnumFacing.func_82600_a((int)i);
                    if (!box.isFaceAtEdge(context, facing)) continue;
                    if (this.neighborCache[i] == null) {
                        BlockPos pos = this.parent.func_174877_v().func_177972_a(facing);
                        ConnectedBlock block2 = blocks.get(pos);
                        if (block2 == null) {
                            TileEntity te = this.parent.func_145831_w().func_175625_s(pos);
                            block2 = te instanceof TileEntityLittleTiles ? new ConnectedBlock((TileEntityLittleTiles)te, startTile) : EMPTY;
                            blocks.put(pos, block2);
                        }
                        this.neighborCache[i] = block2;
                    }
                    if ((block = this.neighborCache[i]).isEmpty()) continue;
                    LittleBox copyBox = box.copy();
                    copyBox.sub(context.size * facing.func_82601_c(), context.size * facing.func_96559_d(), context.size * facing.func_82599_e());
                    LittleGridContext used = context;
                    if (block.getContext().size > context.size) {
                        copyBox.convertTo(context, block.getContext());
                        used = block.getContext();
                    }
                    block.performSearchIn(boxes, blocks, startTile, false, used, copyBox);
                }
            }
        }

        public LittleGridContext getContext() {
            return this.parent.getContext();
        }

        public boolean isEmpty() {
            return this.potential.isEmpty();
        }
    }
}

