/*
 * Decompiled with CFR 0.152.
 */
package dan.morefurnaces.gui;

import dan.morefurnaces.FurnaceType;
import dan.morefurnaces.gui.Textures;
import dan.morefurnaces.inventory.ContainerIronFurnace;
import dan.morefurnaces.tileentity.TileEntityIronFurnace;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiMoreFurnace
extends GuiContainer {
    private final TileEntityIronFurnace furnace;
    private final GUI type;

    public GuiMoreFurnace(GUI type, ContainerIronFurnace invFurnace) {
        super((Container)invFurnace);
        this.furnace = invFurnace.getTileEntity();
        this.type = type;
        this.field_146999_f = 176;
        this.field_147000_g = type.bgHeight;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int px;
        int top;
        int left;
        this.field_146297_k.func_110434_K().func_110577_a(this.type.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.furnace.isBurning()) {
            switch (this.type) {
                case IRON: 
                case COPPER: 
                case NETHERRACK: {
                    left = 57;
                    top = 37;
                    break;
                }
                case SILVER: 
                case GOLD: {
                    left = 64;
                    top = 37;
                    break;
                }
                case DIAMOND: {
                    left = 64;
                    top = 55;
                    break;
                }
                default: {
                    left = 57;
                    top = 67;
                }
            }
            px = this.getBurnLeftScaled();
            this.func_73729_b(this.field_147003_i + left, this.field_147009_r + top + 13 - px, 176, 13 - px, 14, px);
        }
        if (this.furnace.isActive()) {
            if (this.type == GUI.OBSIDIAN) {
                int pxTop = this.getCookProgressScaled(0);
                int pxBottom = this.getCookProgressScaled(1);
                this.func_73729_b(this.field_147003_i + 79, this.field_147009_r + 18, 176, 13, pxTop + 1, 16);
                this.func_73729_b(this.field_147003_i + 79, this.field_147009_r + 44, 176, 13, pxBottom + 1, 16);
            } else {
                switch (this.type) {
                    case IRON: 
                    case COPPER: 
                    case NETHERRACK: {
                        left = 79;
                        top = 35;
                        break;
                    }
                    case SILVER: 
                    case GOLD: {
                        left = 81;
                        top = 35;
                        break;
                    }
                    default: {
                        left = 81;
                        top = 53;
                    }
                }
                px = this.getCookProgressScaled(0);
                this.func_73729_b(this.field_147003_i + left, this.field_147009_r + top, 176, 13, px + 1, 16);
            }
        }
    }

    private int getCookProgressScaled(int id) {
        return (int)(24.0f * this.furnace.getCookProgress(id));
    }

    private int getBurnLeftScaled() {
        return (int)(this.furnace.getBurnTimeRemaining() * 13.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
    }

    public static enum GUI {
        IRON(Textures.IRON, FurnaceType.IRON, 166),
        GOLD(Textures.GOLD, FurnaceType.GOLD, 166),
        DIAMOND(Textures.DIAMOND, FurnaceType.DIAMOND, 202),
        OBSIDIAN(Textures.OBSIDIAN, FurnaceType.OBSIDIAN, 196),
        NETHERRACK(Textures.NETHERRACK, FurnaceType.NETHERRACK, 166),
        COPPER(Textures.COPPER, FurnaceType.COPPER, 166),
        SILVER(Textures.SILVER, FurnaceType.SILVER, 166);

        private final ResourceLocation texture;
        private final FurnaceType mainType;
        private static final int fuelWidth = 14;
        private static final int fuelHeight = 13;
        private static final int cookWidth = 24;
        private static final int cookHeight = 16;
        private final int cookY = 13;
        private static final int bgWidth = 176;
        private final int bgHeight;
        private static final int barX = 79;
        private static final int bar0Y = 18;
        private static final int bar1Y = 44;

        private GUI(ResourceLocation texture, FurnaceType mainType, int bgHeight) {
            this.texture = texture;
            this.mainType = mainType;
            this.bgHeight = bgHeight;
        }

        protected ContainerIronFurnace makeContainer(InventoryPlayer player, TileEntityIronFurnace furnace) {
            return new ContainerIronFurnace(player, furnace, this.mainType);
        }

        public static GuiScreen buildGui(InventoryPlayer invPlayer, TileEntityIronFurnace invFurnace) {
            GUI type = GUI.values()[invFurnace.getType().ordinal()];
            ContainerIronFurnace container = type.makeContainer(invPlayer, invFurnace);
            return new GuiMoreFurnace(type, container);
        }
    }
}

