/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import java.util.EnumMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import thelm.packagedauto.client.gui.IGuiProvider;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.InventoryTileBase;

public abstract class TileBase
extends TileEntity
implements IWorldNameable,
IGuiProvider {
    protected InventoryTileBase inventory = new InventoryTileBase(this, 0);
    protected EnergyStorage energyStorage = new EnergyStorage(this, 0);
    public String customName = "";
    protected int placerID = -1;
    protected IItemHandler unsidedItemHandler = null;
    protected EnumMap<EnumFacing, IItemHandler> sidedItemHandlers = new EnumMap(EnumFacing.class);

    public InventoryTileBase getInventory() {
        return this.inventory;
    }

    public void setInventory(InventoryTileBase inventory) {
        this.inventory = inventory;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void setEnergyStorage(EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    public void setPlacer(EntityPlayer placer) {
    }

    public int getPlacerID() {
        return this.placerID;
    }

    protected abstract String getLocalizedName();

    public String func_70005_c_() {
        return this.customName.isEmpty() ? this.getLocalizedName() : this.customName;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean func_145818_k_() {
        return !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        if (!name.isEmpty()) {
            this.customName = name;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readSyncNBT(nbt);
        this.inventory.readFromNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeSyncNBT(nbt);
        this.inventory.writeToNBT(nbt);
        return nbt;
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Name")) {
            this.customName = nbt.func_74779_i("Name");
        }
        this.energyStorage.readFromNBT(nbt);
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        if (!this.customName.isEmpty()) {
            nbt.func_74778_a("Name", this.customName);
        }
        this.energyStorage.writeToNBT(nbt);
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readSyncNBT(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -10, this.func_189517_E_());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readSyncNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_82580_o("ForgeData");
        nbt.func_82580_o("ForgeCaps");
        this.writeSyncNBT(nbt);
        return nbt;
    }

    public void syncTile(boolean rerender) {
        if (this.field_145850_b != null && this.field_145850_b.func_175667_e(this.field_174879_c)) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2 + (rerender ? 4 : 0));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY && this.energyStorage.getMaxEnergyStored() > 0 || super.hasCapability(capability, from);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.inventory instanceof ISidedInventory && facing != null) {
                if (this.sidedItemHandlers.containsKey(facing)) {
                    return (T)this.sidedItemHandlers.get(facing);
                }
                SidedInvWrapper handler = new SidedInvWrapper((ISidedInventory)this.inventory, facing);
                this.sidedItemHandlers.put(facing, (IItemHandler)handler);
                return (T)handler;
            }
            if (this.unsidedItemHandler != null) {
                return (T)this.unsidedItemHandler;
            }
            this.unsidedItemHandler = new InvWrapper((IInventory)this.inventory);
            return (T)this.unsidedItemHandler;
        }
        if (capability == CapabilityEnergy.ENERGY && this.energyStorage.getMaxEnergyStored() > 0) {
            return (T)((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }
}

