/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.xtones.config;

import info.tehnut.xtones.config.TooltipVisibility;
import info.tehnut.xtones.network.XtonesNetwork;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Config(modid="xtones")
@Mod.EventBusSubscriber(modid="xtones")
public final class XtonesConfig {
    @Config.Comment(value={"How chiseling Xtones blocks should function. [Requires \"Chisel\" by the Chisel Team to be installed]", "0 - Chisel the Stone Tile into the first variant of each registered Xtone block. This makes the individual recipes useless.", "1 - Chisel between each variant of the Xtones blocks. This makes the cycling useless.", "2 - Disable Chisel compatibility altogether.", "Example images can be found on the ChiselTones CurseForge page. Functionality is exactly the same."})
    @Config.RangeInt(min=0, max=2)
    public static int chiselMode = 0;
    @Config.Comment(value={"Disables all recipes except the one for the Stone Tile.", "Mainly for use with Chisel installed and chiselMode being set to 0."})
    public static boolean disableXtoneRecipes = false;
    @Config.Comment(value={"Disables the ability to cycle between variants via keybind.", "Mainly for use with Chisel installed and chiselMode being set to 1."})
    public static boolean disableScrollCycling = false;
    @Config.Comment(value={"Enables the search bar on the Xtones creative tab"})
    public static boolean searchableCreativeTab = true;
    @Config.Comment(value={"Visibility of the cycling tooltip on Xtone items", "   visible - The tooltip will always be visible", "   shift - The tooltip will only be visible when shift is held", "   hidden - The tooltip will not be visible"})
    public static TooltipVisibility cyclingTooltip = TooltipVisibility.visible;

    private XtonesConfig() {
    }

    public static boolean hasXtoneRecipes() {
        return !disableXtoneRecipes;
    }

    public static boolean hasXtoneCycling() {
        return !disableScrollCycling;
    }

    @SubscribeEvent
    static void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("xtones".equals(event.getModID())) {
            ConfigManager.sync((String)"xtones", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        XtonesNetwork.syncConfig((EntityPlayerMP)event.player);
    }
}

