/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.data.IAEStack;
import appeng.core.features.registries.cell.CreativeCellHandler;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.storage.TileDrive;
import java.util.Collections;
import net.minecraft.item.ItemStack;

public class DriveWatcher<T extends IAEStack<T>>
extends MEInventoryHandler<T> {
    private int oldStatus = 0;
    private final ItemStack is;
    private final ICellHandler handler;
    private final TileDrive drive;
    private final IActionSource source;

    public DriveWatcher(ICellInventoryHandler<T> i, ItemStack is, ICellHandler han, TileDrive drive) {
        super(i, i.getChannel());
        this.is = is;
        this.handler = han;
        this.drive = drive;
        this.source = new MachineSource(drive);
    }

    public int getStatus() {
        return this.handler.getStatusForCell(this.is, (ICellInventoryHandler)this.getInternal());
    }

    @Override
    public T injectItems(T input, Actionable type, IActionSource src) {
        long size = input.getStackSize();
        T remainder = super.injectItems(input, type, src);
        if (type == Actionable.MODULATE && (remainder == null || remainder.getStackSize() != size)) {
            int newStatus = this.getStatus();
            if (newStatus != this.oldStatus) {
                this.drive.blinkCell(this.getSlot());
                this.oldStatus = newStatus;
            }
            if (this.drive.getProxy().isActive() && !(this.handler instanceof CreativeCellHandler)) {
                try {
                    this.drive.getProxy().getStorage().postAlterationOfStoredItems(this.getChannel(), Collections.singletonList(input.copy().setStackSize(input.getStackSize() - (remainder == null ? 0L : remainder.getStackSize()))), this.source);
                }
                catch (GridAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return remainder;
    }

    @Override
    public T extractItems(T request, Actionable type, IActionSource src) {
        T extractable = super.extractItems(request, type, src);
        if (type == Actionable.MODULATE && extractable != null) {
            int newStatus = this.getStatus();
            if (newStatus != this.oldStatus) {
                this.drive.blinkCell(this.getSlot());
                this.oldStatus = newStatus;
            }
            if (this.drive.getProxy().isActive() && !(this.handler instanceof CreativeCellHandler)) {
                try {
                    this.drive.getProxy().getStorage().postAlterationOfStoredItems(this.getChannel(), Collections.singletonList(request.copy().setStackSize(-extractable.getStackSize())), this.source);
                }
                catch (GridAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return extractable;
    }
}

