/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.me.GridAccessException;
import appeng.me.helpers.IGridProxyable;
import appeng.me.storage.ITickingMonitor;
import appeng.parts.misc.PartStorageBus;
import appeng.util.item.AEItemStack;
import com.google.common.primitives.Ints;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

class ItemRepositoryAdapter
implements IMEInventory<IAEItemStack>,
IBaseMonitor<IAEItemStack>,
ITickingMonitor {
    private final Object2ObjectMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new Object2ObjectOpenHashMap();
    private IActionSource mySource;
    private final IItemRepository itemRepository;
    private final IGridProxyable proxyable;
    private final InventoryCache cache;
    private AccessRestriction access;

    ItemRepositoryAdapter(IItemRepository itemRepository, IGridProxyable proxy) {
        this.itemRepository = itemRepository;
        this.proxyable = proxy;
        this.cache = new InventoryCache(this.itemRepository);
        if (this.proxyable instanceof PartStorageBus) {
            PartStorageBus partStorageBus = (PartStorageBus)this.proxyable;
            this.access = (AccessRestriction)partStorageBus.getConfigManager().getSetting(Settings.ACCESS);
        }
        this.cache.update();
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack iox, Actionable type, IActionSource src) {
        ItemStack inputStack = iox.getCachedItemStack(iox.getStackSize());
        ItemStack remaining = this.itemRepository.insertItem(inputStack, type == Actionable.SIMULATE);
        if (type == Actionable.SIMULATE) {
            iox.setCachedItemStack(inputStack);
        } else if (!remaining.func_190926_b()) {
            iox.setCachedItemStack(remaining);
        }
        if (remaining == inputStack) {
            return iox;
        }
        if (type == Actionable.MODULATE) {
            IAEItemStack added = (IAEItemStack)iox.copy().setStackSize(iox.getStackSize() - (long)remaining.func_190916_E());
            this.cache.currentlyCached.add(added);
            this.postDifference(Collections.singletonList(added));
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return AEItemStack.fromItemStack(remaining);
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
        int remainingSize = Ints.saturatedCast((long)request.getStackSize());
        boolean simulate = mode == Actionable.SIMULATE;
        ItemStack extracted = this.itemRepository.extractItem(request.getDefinition(), remainingSize, simulate);
        if (extracted.func_190916_E() > remainingSize) {
            AELog.warn("Mod that provided item handler %s is broken. Returned %s items while only requesting %d.", this.itemRepository.getClass().getName(), extracted.toString(), remainingSize);
            extracted.func_190920_e(remainingSize);
        }
        if (!extracted.func_190926_b()) {
            AEItemStack extractedAEItemStack = AEItemStack.fromItemStack(extracted);
            if (mode == Actionable.MODULATE) {
                IAEItemStack cachedStack = this.cache.currentlyCached.findPrecise(request);
                if (cachedStack != null) {
                    cachedStack.decStackSize(extractedAEItemStack.getStackSize());
                    this.postDifference(Collections.singletonList(extractedAEItemStack.copy().setStackSize(-extractedAEItemStack.getStackSize())));
                }
                try {
                    this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
            return extractedAEItemStack;
        }
        return null;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        return this.cache.getAvailableItems(out);
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    private void postDifference(Iterable<IAEItemStack> a) {
        ObjectIterator i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry l = (Map.Entry)i.next();
            IMEMonitorHandlerReceiver key = (IMEMonitorHandlerReceiver)l.getKey();
            if (key.isValid(l.getValue())) {
                key.postChange(this, a, this.mySource);
                continue;
            }
            i.remove();
        }
    }

    @Override
    public TickRateModulation onTick() {
        List<IAEItemStack> changes = this.cache.update();
        if (!changes.isEmpty() && this.access.hasPermission(AccessRestriction.READ)) {
            this.postDifference(changes);
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public void setActionSource(IActionSource mySource) {
        this.mySource = mySource;
    }

    private static class InventoryCache {
        private IItemList<IAEItemStack> currentlyCached = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        private final IItemRepository iItemRepository;

        public InventoryCache(IItemRepository iItemRepository) {
            this.iItemRepository = iItemRepository;
        }

        public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
            this.currentlyCached.iterator().forEachRemaining(out::add);
            return out;
        }

        public List<IAEItemStack> update() {
            ArrayList<IAEItemStack> changes = new ArrayList<IAEItemStack>();
            IItemList currentlyOnStorage = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
            this.iItemRepository.getAllItems().stream().map(s -> (IAEItemStack)AEItemStack.fromItemStack(s.itemPrototype).setStackSize(s.count)).forEach(currentlyOnStorage::add);
            for (IAEItemStack is : this.currentlyCached) {
                is.setStackSize(-is.getStackSize());
            }
            for (IAEItemStack is : currentlyOnStorage) {
                this.currentlyCached.add(is);
            }
            for (IAEItemStack is : this.currentlyCached) {
                if (is.getStackSize() == 0L) continue;
                changes.add(is);
            }
            this.currentlyCached = currentlyOnStorage;
            return changes;
        }
    }
}

