/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.SortDir;
import appeng.api.storage.data.IAEItemStack;
import appeng.integration.Integrations;
import appeng.integration.abstraction.IInvTweaks;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Comparator;

public class ItemSorters {
    private static SortDir Direction = SortDir.ASCENDING;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_NAME = (o1, o2) -> {
        int cmp = Platform.getItemDisplayName(o1).compareToIgnoreCase(Platform.getItemDisplayName(o2));
        return ItemSorters.applyDirection(cmp);
    };
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_MOD = (o1, o2) -> {
        AEItemStack op1 = (AEItemStack)o1;
        AEItemStack op2 = (AEItemStack)o2;
        int cmp = op1.getModID().compareToIgnoreCase(op2.getModID());
        if (cmp == 0) {
            cmp = Platform.getItemDisplayName(o1).compareToIgnoreCase(Platform.getItemDisplayName(o2));
        }
        return ItemSorters.applyDirection(cmp);
    };
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_SIZE = (o1, o2) -> {
        int cmp = Long.compare(o2.getStackSize(), o1.getStackSize());
        return ItemSorters.applyDirection(cmp);
    };
    private static IInvTweaks api;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_INV_TWEAKS;

    public static void init() {
        if (api != null) {
            return;
        }
        api = Integrations.invTweaks().isEnabled() ? Integrations.invTweaks() : null;
    }

    public static int compareLong(long a, long b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    private static SortDir getDirection() {
        return Direction;
    }

    public static void setDirection(SortDir direction) {
        Direction = direction;
    }

    private static int applyDirection(int cmp) {
        if (ItemSorters.getDirection() == SortDir.ASCENDING) {
            return cmp;
        }
        return -cmp;
    }

    static {
        CONFIG_BASED_SORT_BY_INV_TWEAKS = (o1, o2) -> {
            if (api == null) {
                return CONFIG_BASED_SORT_BY_NAME.compare((IAEItemStack)o1, (IAEItemStack)o2);
            }
            int cmp = api.compareItems(o1.createItemStack(), o2.createItemStack());
            return ItemSorters.applyDirection(cmp);
        };
    }
}

