/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.dimension.arena;

import com.sofodev.armorplus.common.dimension.arena.WorldGenFloatingIsland;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorArena
implements IChunkGenerator {
    private final Random rand;
    protected static final IBlockState FILLER_BLOCK = Blocks.field_150371_ca.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    public NoiseGeneratorOctaves depthNoise;
    public NoiseGeneratorOctaves scaleNoise;
    private final World world;
    private final boolean mapFeaturesEnabled;
    private final BlockPos spawnPoint;
    private NoiseGeneratorSimplex islandNoise;
    private double[] depthBuffer;
    private Biome[] biomesForGeneration;
    double[] mainNoiseRegion;
    double[] minLimitRegion;
    double[] maxLimitRegion;
    private final WorldGenFloatingIsland endIslands = new WorldGenFloatingIsland(FILLER_BLOCK);
    private int chunkX = 0;
    private int chunkZ = 0;

    public ChunkGeneratorArena(World world, boolean isMapFeaturesEnabled, long seed, BlockPos spawnPoint) {
        this.world = world;
        this.mapFeaturesEnabled = isMapFeaturesEnabled;
        this.spawnPoint = spawnPoint;
        this.rand = new Random(seed);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.islandNoise = new NoiseGeneratorSimplex(this.rand);
        InitNoiseGensEvent.ContextEnd ctx = new InitNoiseGensEvent.ContextEnd(this.minLimitPerlinNoise, this.maxLimitPerlinNoise, this.mainPerlinNoise, this.depthNoise, this.scaleNoise, this.islandNoise);
        ctx = (InitNoiseGensEvent.ContextEnd)TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.minLimitPerlinNoise = ctx.getLPerlin1();
        this.maxLimitPerlinNoise = ctx.getLPerlin2();
        this.mainPerlinNoise = ctx.getPerlin();
        this.depthNoise = ctx.getDepth();
        this.scaleNoise = ctx.getScale();
        this.islandNoise = ctx.getIsland();
    }

    public Chunk func_185932_a(int x, int z) {
        this.chunkX = x;
        this.chunkZ = z;
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.setBlocksInChunk(x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        IntStream.range(0, biomeArray.length).forEach(i -> {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        });
        chunk.func_76603_b();
        return chunk;
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        long xzOffsetPos = (long)x * (long)x + (long)z * (long)z;
        long xOffsetPos = (long)x * (long)x;
        long zOffsetPos = (long)z * (long)z;
        for (int xOffset = 0; xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                if (xzOffsetPos < 16L) {
                    primer.func_177855_a(xOffset, 17, zOffset, FILLER_BLOCK);
                }
                if (xzOffsetPos < 32L) {
                    primer.func_177855_a(xOffset, 16, zOffset, FILLER_BLOCK);
                }
                if (xzOffsetPos != 1L) continue;
                primer.func_177855_a(xOffset, 18, zOffset, Blocks.field_150343_Z.func_176223_P());
            }
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        ChunkGeneratorArena.setFallingInstantly(true);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16)).func_180624_a(this.world, this.world.field_73012_v, blockpos);
        long xzOffsetPos = (long)chunkX * (long)chunkX + (long)chunkZ * (long)chunkZ;
        if (xzOffsetPos > 4096L) {
            // empty if block
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        ChunkGeneratorArena.setFallingInstantly(false);
    }

    private static void setFallingInstantly(boolean value) {
        BlockFalling.field_149832_M = value;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }
}

