/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.proxy;

import com.sofodev.armorplus.api.caps.abilities.AbilityDataHandler;
import com.sofodev.armorplus.common.compat.ICompatibility;
import com.sofodev.armorplus.common.compat.tinkers.TiC;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.ModBlocks;
import com.sofodev.armorplus.common.registry.ModCompatibility;
import com.sofodev.armorplus.common.registry.ModDimensions;
import com.sofodev.armorplus.common.registry.ModEntities;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.registry.ModOreDicts;
import com.sofodev.armorplus.common.registry.ModRecipes;
import com.sofodev.armorplus.common.registry.commands.CommandArmorPlus;
import com.sofodev.armorplus.common.registry.constants.APItems;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.guardianoverlord.EntityGuardianOverlord;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.guardianoverlord.projectile.EntityFreezeBomb;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.EntitySkeletalKing;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.projectile.EntityWitherMinion;
import com.sofodev.armorplus.common.registry.items.armors.ArmorMaterials;
import com.sofodev.armorplus.common.util.LoaderUtils;
import com.sofodev.armorplus.common.worldgen.OreGen;
import com.sofodev.armorplus.common.worldgen.nbt.StructureGenNBT;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.command.ICommand;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        if (ModConfig.Experimental.enableExperimentalMode) {
            AbilityDataHandler.register();
        }
        new ArmorMaterials();
        ModBlocks.registerBlocks();
        ModItems.registerItems();
        APItems.registerItemNames();
        APItems.registerWeaponsA();
        APItems.registerWeaponsB();
        ModItems.registerTCItems();
        APItems.registerTCItemNames();
        this.registerEntityFixes();
        ModEntities.registerEntitySettings();
        this.registerWorldGenerator(new OreGen(), new StructureGenNBT());
        if (LoaderUtils.isTiCIntegrationEnabled()) {
            TiC.instance().preInit(event);
        }
        ModDimensions.init();
        ModCompatibility.registerModCompat();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.PRE_INIT);
        LogHelper.info((Object)"Finished PreInitialization");
    }

    private void registerEntityFixes() {
        EntityGuardianOverlord.registerFixesElderGuardian(DataFixesManager.func_188279_a());
        EntityFreezeBomb.registerFixesFreezeBomb(DataFixesManager.func_188279_a());
        EntitySkeletalKing.registerFixesSkeletalKing(DataFixesManager.func_188279_a());
        EntityWitherMinion.registerFixesWitherMinion(DataFixesManager.func_188279_a());
    }

    public void init(FMLInitializationEvent event) {
        ModOreDicts.registerOreDictEntries();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.INIT);
        ModRecipes.init();
        if (LoaderUtils.isTiCIntegrationEnabled()) {
            TiC.instance().init(event);
        }
        Arrays.stream(ModItems.ardite).forEach(armor -> armor.setRepairStack(armor.field_77878_bZ.getRepairStack()));
        Arrays.stream(ModItems.cobalt).forEach(armor -> armor.setRepairStack(armor.field_77878_bZ.getRepairStack()));
        Arrays.stream(ModItems.manyullyn).forEach(armor -> armor.setRepairStack(armor.field_77878_bZ.getRepairStack()));
        Arrays.stream(ModItems.knightSlime).forEach(armor -> armor.setRepairStack(armor.field_77878_bZ.getRepairStack()));
        Arrays.stream(ModItems.pigIron).forEach(armor -> armor.setRepairStack(armor.field_77878_bZ.getRepairStack()));
        LogHelper.getLogger((String)"armorplus").info("Finished Initialization");
    }

    public void postInit(FMLPostInitializationEvent event) {
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.POST_INIT);
        if (LoaderUtils.isTiCIntegrationEnabled()) {
            TiC.instance().postInit(event);
        }
        LogHelper.getLogger((String)"armorplus").info("Finished PostInitialization");
    }

    public void modMapping(FMLModIdMappingEvent event) {
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.MAPPING);
    }

    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandArmorPlus());
    }

    private void registerWorldGenerator(IWorldGenerator ... generators) {
        IntStream.range(0, generators.length).forEachOrdered(i -> GameRegistry.registerWorldGenerator((IWorldGenerator)generators[i], (int)i));
    }
}

