/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry;

import com.sofodev.armorplus.api.crafting.IRecipe;
import com.sofodev.armorplus.api.crafting.base.BaseShapedOreRecipe;
import com.sofodev.armorplus.api.crafting.base.BaseShapelessOreRecipe;
import com.sofodev.armorplus.api.crafting.workbench.WorkbenchRegistry;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.ModBlocks;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.registry.ModOreDicts;
import com.sofodev.armorplus.common.util.LoaderUtils;
import com.sofodev.armorplus.common.util.Utils;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public class ModRecipes {
    private static String stoneBrick = "stonebrick";

    public static void init() {
        ModRecipes.addShapedRecipes();
        ModRecipes.addShapelessRecipes();
        if (LoaderUtils.isTOPIntegrationEnabled()) {
            ModRecipes.addIntegrationShapelessRecipes();
        }
    }

    private static void addIntegrationShapelessRecipes() {
        ModRecipes.addTOPRecipes("ardite_helmet", "chicken_helmet", "coal_helmet", "cobalt_helmet", "emerald_helmet", "ender_dragon_helmet", "guardian_helmet", "knight_slime_helmet", "lapis_helmet", "lava_helmet", "manyullyn_helmet", "obsidian_helmet", "pig_iron_helmet", "redstone_helmet", "slime_helmet", "super_star_helmet", "the_ultimate_helmet");
    }

    private static void addTOPRecipes(String ... names) {
        Arrays.stream(names).forEach(ModRecipes::addTOPRecipe);
    }

    private static void addTOPRecipe(String name) {
        NBTTagCompound nbttagc = new NBTTagCompound();
        nbttagc.func_74768_a("theoneprobe", 1);
        Item helmet = Item.func_111206_d((String)("armorplus:" + name));
        if (helmet != null) {
            ItemStack stack = ItemStackUtils.getItemStack((Object)helmet);
            NBTTagCompound oldNBT = stack.func_77978_p();
            if (oldNBT != null) {
                nbttagc.func_179237_a(oldNBT);
            }
            stack.func_77982_d(nbttagc);
            if (!stack.func_190926_b()) {
                GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL(name), (ResourceLocation)Utils.setRL("top"), (ItemStack)stack, (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)helmet), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((String)"theoneprobe", (String)"probe")})});
            }
        }
    }

    private static void addShapedRecipes() {
        if (!ModConfig.MainConfig.global.useJsonRecipes) {
            GameRegistry.addShapedRecipe((ResourceLocation)Utils.setRL("block_lava_crystal"), (ResourceLocation)Utils.setRL("lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaCrystal), (Object[])new Object[]{"CCC", "CCC", "CCC", Character.valueOf('C'), ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)0)});
            GameRegistry.addShapedRecipe((ResourceLocation)Utils.setRL("block_infused_lava_crystal"), (ResourceLocation)Utils.setRL("infused_lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockInfusedLavaCrystal), (Object[])new Object[]{"CCC", "CCC", "CCC", Character.valueOf('C'), ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1)});
            GameRegistry.addShapedRecipe((ResourceLocation)Utils.setRL("block_compressed_lava_crystal"), (ResourceLocation)Utils.setRL("compressed_lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedLavaCrystal), (Object[])new Object[]{"CCC", "CCC", "CCC", Character.valueOf('C'), ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaCrystal)});
            GameRegistry.addShapedRecipe((ResourceLocation)Utils.setRL("block_compressed_infused_lava_crystal"), (ResourceLocation)Utils.setRL("compressed_infused_lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedInfusedLavaCrystal), (Object[])new Object[]{"CCC", "CCC", "CCC", Character.valueOf('C'), ItemStackUtils.getItemStack((Object)ModBlocks.blockInfusedLavaCrystal)});
            GameRegistry.addShapedRecipe((ResourceLocation)Utils.setRL("workbench"), (ResourceLocation)Utils.setRL("benches"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.benches[0]), (Object[])new Object[]{"LCL", "OTO", "O O", Character.valueOf('T'), Blocks.field_150462_ai, Character.valueOf('O'), Blocks.field_150402_ci, Character.valueOf('L'), ItemStackUtils.getItemStack((Object)Items.field_151100_aR, (int)4), Character.valueOf('C'), ModItems.itemLavaCrystal});
            WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, new ItemStack((Block)ModBlocks.benches[0]), "LCL", "OTO", "O O", Character.valueOf('T'), Blocks.field_150462_ai, Character.valueOf('O'), Blocks.field_150402_ci, Character.valueOf('L'), ItemStackUtils.getItemStack((Object)Items.field_151100_aR, (int)4), Character.valueOf('C'), ModItems.itemLavaCrystal));
            WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, new ItemStack((Block)ModBlocks.blockEmptyDisplay), "   ", "PPP", "SSS", Character.valueOf('S'), Blocks.field_150333_U, Character.valueOf('P'), Items.field_151042_j));
            if (ModConfig.RegistryConfig.recipes.enableElytraRecipe) {
                WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, new ItemStack(Items.field_185160_cR, 1), "ESE", "SNS", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.materials, 1, 3), Character.valueOf('S'), Items.field_151007_F, Character.valueOf('N'), Items.field_151156_bN));
            }
            if (ModConfig.RegistryConfig.recipes.enableChainArmorRecipes) {
                WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151020_U, 1), "   ", "CCC", "C C", Character.valueOf('C'), "chainmail"), new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151020_U, 1), "CCC", "C C", "   ", Character.valueOf('C'), "chainmail"), new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151023_V, 1), "C C", "CCC", "CCC", Character.valueOf('C'), "chainmail"), new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151022_W, 1), "CCC", "C C", "C C", Character.valueOf('C'), "chainmail"), new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151029_X, 1), "   ", "C C", "C C", Character.valueOf('C'), "chainmail"), new BaseShapedOreRecipe(3, new ItemStack((Item)Items.field_151029_X, 1), "C C", "C C", "   ", Character.valueOf('C'), "chainmail"));
            }
            WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)12, (int)0), "SS ", "S S", " SS", Character.valueOf('S'), "ingotIron"));
            WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedObsidian), "OOO", "OOO", "OOO", Character.valueOf('O'), "obsidian"));
            if (ModConfig.RegistryConfig.recipes.enableRedstoneAppleRecipes) {
                WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, ItemStackUtils.getItemStack((Object)ModItems.itemRedstoneApple), "RRR", "RAR", "RRR", Character.valueOf('R'), "dustRedstone", Character.valueOf('A'), Items.field_151034_e));
                WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, ItemStackUtils.getItemStack((Object)ModItems.itemRedstoneApple, (int)1), "BBB", "BAB", "BBB", Character.valueOf('B'), "blockRedstone", Character.valueOf('A'), Items.field_151034_e));
            }
            WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, new ItemStack((Block)ModBlocks.blockLavaNetherBrick, 4), " N ", "NLN", " N ", Character.valueOf('L'), Items.field_151129_at, Character.valueOf('N'), Blocks.field_150385_bj));
            IntStream.range(0, ModOreDicts.colors.length).forEachOrdered(i -> {
                ModRecipes.addRecipeCastle(ModBlocks.stoneBricks[i], ModOreDicts.colors[i]);
                ModRecipes.addRecipeCastleCorner((Block)ModBlocks.stoneBrickCorners[i], ModOreDicts.colors[i]);
                ModRecipes.addRecipeCastleTower(ModBlocks.stoneBrickTowers[i], ModOreDicts.colors[i]);
                ModRecipes.addRecipeCastleWall((Block)ModBlocks.stonebrickWalls[i], ModOreDicts.colors[i]);
                ModRecipes.addRecipeStoneBrick(ModOreDicts.colors[i]);
            });
        }
    }

    private static void addShapelessRecipes() {
        if (!ModConfig.MainConfig.global.useJsonRecipes) {
            GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("lava_crystal_from_block"), (ResourceLocation)Utils.setRL("lava_crystal"), (ItemStack)ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)9, (int)0), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaCrystal)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("infused_lava_crystal_from_block"), (ResourceLocation)Utils.setRL("infused_lava_crystal"), (ItemStack)ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)9, (int)1), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModBlocks.blockInfusedLavaCrystal)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("block_lava_crystal_from_compression"), (ResourceLocation)Utils.setRL("lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockLavaCrystal, (int)9, (int)0), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedLavaCrystal)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("block_infused_lava_crystal_from_compression"), (ResourceLocation)Utils.setRL("infused_lava_block"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.blockInfusedLavaCrystal, (int)9, (int)0), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedInfusedLavaCrystal)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("obsidian_from_compression"), (ResourceLocation)Utils.setRL("obsidian"), (ItemStack)ItemStackUtils.getItemStack((Object)Blocks.field_150343_Z, (int)9, (int)0), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedObsidian)})});
        }
        GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("info_book"), (ResourceLocation)Utils.setRL("item_book"), (ItemStack)ItemStackUtils.getItemStack((Object)ModItems.bookInfo), (Ingredient[])new Ingredient[]{Ingredient.func_193368_a((Item[])new Item[]{Items.field_151122_aG}), Ingredient.func_193368_a((Item[])new Item[]{Items.field_151044_h})});
        GameRegistry.addShapelessRecipe((ResourceLocation)Utils.setRL("lava_cactus"), (ResourceLocation)Utils.setRL("lava_cactus"), (ItemStack)ItemStackUtils.getItemStack((Object)ModBlocks.lavaCactus, (int)1, (int)0), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)Blocks.field_150434_aF)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1)})});
    }

    private static void addRecipeCastleCorner(Block block, String color) {
        WorkbenchRegistry.addRecipe(new BaseShapedOreRecipe(3, new ItemStack(block), "   ", "  S", " SS", Character.valueOf('S'), stoneBrick + color), new BaseShapedOreRecipe(3, new ItemStack(block), "   ", "S  ", "SS ", Character.valueOf('S'), stoneBrick + color), new BaseShapedOreRecipe(3, new ItemStack(block), "  S", " SS", "   ", Character.valueOf('S'), stoneBrick + color), new BaseShapedOreRecipe(3, new ItemStack(block), "S  ", "SS ", "   ", Character.valueOf('S'), stoneBrick + color));
    }

    private static void addRecipeCastleTower(Block block, String color) {
        WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, new ItemStack(block), "   ", "S S", "SSS", Character.valueOf('S'), stoneBrick + color));
        WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, new ItemStack(block), "S S", "SSS", "   ", Character.valueOf('S'), stoneBrick + color));
    }

    private static void addRecipeCastleWall(Block block, String color) {
        WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, new ItemStack(block, 6), "   ", "SSS", "SSS", Character.valueOf('S'), stoneBrick + color));
        WorkbenchRegistry.addRecipe((IRecipe)new BaseShapedOreRecipe(3, new ItemStack(block, 6), "SSS", "SSS", "   ", Character.valueOf('S'), stoneBrick + color));
    }

    private static void addRecipeCastle(Block block, String color) {
        WorkbenchRegistry.addRecipe(new BaseShapelessOreRecipe(new ItemStack(block, 3), stoneBrick + color + "Corner"), new BaseShapelessOreRecipe(new ItemStack(block, 5), stoneBrick + color + "Tower"), new BaseShapelessOreRecipe(new ItemStack(block), stoneBrick + color + "Wall"), new BaseShapedOreRecipe(3, new ItemStack(block), " S ", "SCS", " S ", Character.valueOf('S'), stoneBrick, Character.valueOf('C'), "dye" + color));
    }

    private static void addRecipeStoneBrick(String color) {
        WorkbenchRegistry.addRecipe((IRecipe)new BaseShapelessOreRecipe(new ItemStack(Blocks.field_150417_aV), stoneBrick + color));
    }
}

