/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.base.special;

import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.items.base.ItemSpecialPickaxe;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public enum Pickaxes {
    COAL(ItemSpecialPickaxe.COAL_PICKAXE, ModConfig.RegistryConfig.coal),
    LAPIS(ItemSpecialPickaxe.LAPIS_PICKAXE, ModConfig.RegistryConfig.lapis),
    REDSTONE(ItemSpecialPickaxe.REDSTONE_PICKAXE, ModConfig.RegistryConfig.redstone),
    EMERALD(ItemSpecialPickaxe.EMERALD_PICKAXE, ModConfig.RegistryConfig.emerald),
    OBSIDIAN(ItemSpecialPickaxe.OBSIDIAN_PICKAXE, ModConfig.RegistryConfig.obsidian),
    INFUSED_LAVA(ItemSpecialPickaxe.INFUSED_LAVA_PICKAXE, ModConfig.RegistryConfig.lava, new String[]{"Smelts blocks to their corresponding smelted form", "Uses Furnace & Lava Infuser recipes"}),
    GUARDIAN(ItemSpecialPickaxe.GUARDIAN_PICKAXE, ModConfig.RegistryConfig.guardian, new String[]{"While underwater:", "Increases mining speed"}){

        @Override
        public void onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
            ItemSpecialPickaxe pickaxe = (ItemSpecialPickaxe)itemstack.func_77973_b();
            float initialDMG = (float)ModConfig.RegistryConfig.guardian.tools.pickaxe.efficiency;
            if (player.func_70090_H() && pickaxe.func_150893_a(itemstack, player.field_70170_p.func_180495_p(pos)) < initialDMG + 10.0f) {
                pickaxe.setEfficiency(initialDMG + 10.0f);
            } else {
                pickaxe.setEfficiency(initialDMG);
            }
        }
    }
    ,
    SUPER_STAR(ItemSpecialPickaxe.SUPER_STAR_PICKAXE, ModConfig.RegistryConfig.super_star, new String[]{"Has a chance to drop:", "Soul Stone when mining Sand", "Netherrack when mining Stone"}){

        @Override
        public void onBlockDestroyed(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase player) {
            if (state == Blocks.field_150348_b.func_176223_P() && Pickaxes.checkMatch()) {
                player.func_70099_a(new ItemStack(Blocks.field_150424_aL, 1), 0.0f);
            }
            if (state == Blocks.field_150354_m.func_176223_P() && Pickaxes.checkMatch()) {
                player.func_70099_a(new ItemStack(Blocks.field_150425_aM, 1), 0.0f);
            }
        }
    }
    ,
    ENDER_DRAGON(ItemSpecialPickaxe.ENDER_DRAGON_PICKAXE, ModConfig.RegistryConfig.ender_dragon, new String[]{"Has a chance to drop:", "Ender Pearl(s) when mining Endstone"}){

        @Override
        public void onBlockDestroyed(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase player) {
            if (state == Blocks.field_150377_bs.func_176223_P() && Pickaxes.checkMatch()) {
                player.func_70099_a(new ItemStack(Items.field_151079_bi, 1), 0.0f);
            }
        }
    };

    private static Random rand;
    private final Item.ToolMaterial material;
    private final TextFormatting formatting;
    private final boolean hasAbility;
    private final String[] abilityDesc;

    private Pickaxes(Item.ToolMaterial material, ModConfig.RegistryConfig.OriginMaterial tools) {
        this(material, tools, false, null);
    }

    private Pickaxes(Item.ToolMaterial material, ModConfig.RegistryConfig.OriginMaterial tools, String[] abilityDesc) {
        this(material, tools, true, abilityDesc);
    }

    private Pickaxes(Item.ToolMaterial material, ModConfig.RegistryConfig.OriginMaterial tools, boolean hasAbility, String[] abilityDesc) {
        this.material = material;
        this.formatting = TextFormatting.func_96300_b((String)tools.tools.itemNameColor);
        this.hasAbility = hasAbility;
        this.abilityDesc = abilityDesc;
    }

    public Item.ToolMaterial getMaterial() {
        return this.material;
    }

    public boolean hasAbilities() {
        return this.hasAbility;
    }

    public String[] getAbilityDesc() {
        return this.abilityDesc;
    }

    public TextFormatting getFormatting() {
        return this.formatting;
    }

    public void onBlockDestroyed(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase player) {
    }

    public void onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
    }

    private static boolean checkMatch() {
        return rand.nextInt(3) == 1;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    static {
        rand = new Random();
    }
}

