/*
 * Decompiled with CFR 0.152.
 */
package com.zook.devtech.api.machines;

import com.zook.devtech.api.machines.IMachineRenderer;
import com.zook.devtech.api.machines.IMoveType;
import com.zook.devtech.api.machines.ITankScalingFunction;
import com.zook.devtech.common.machines.CTMachineBuilder;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IICubeRenderer;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.ITextureArea;
import gregtech.api.recipes.RecipeMap;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.machine.MachineBuilder")
@ZenRegister
public interface IMachineBuilder {
    @ZenMethod
    public static IMachineBuilder create(int id, String name) {
        return new CTMachineBuilder(id, name);
    }

    @ZenMethod
    public IMachineBuilder setRecipeMap(RecipeMap<?> var1);

    @ZenMethod
    public IMachineBuilder setRenderer(String var1);

    @ZenMethod
    public IMachineBuilder setRenderer(IMachineRenderer var1);

    @Optional.Method(modid="multiblocktweaker")
    @ModOnly(value="multiblocktweaker")
    @ZenMethod
    public IMachineBuilder setRenderer(IICubeRenderer var1);

    @ZenMethod
    public IMachineBuilder setRenderer(String var1, String ... var2);

    @ZenMethod
    public IMachineBuilder addTier(int ... var1);

    @ZenMethod
    public IMachineBuilder addTierRange(int var1, int var2);

    @ZenMethod
    public IMachineBuilder addSteamTier(boolean var1, @Optional boolean var2);

    @ZenMethod
    public IMachineBuilder setGenerator();

    @ZenMethod
    public IMachineBuilder setMachine();

    @ZenMethod
    public IMachineBuilder setTankScalingFunction(ITankScalingFunction var1);

    @ZenMethod
    public IMachineBuilder setHasFrontFacing(boolean var1);

    @ZenMethod
    public IMachineBuilder setCanHandleOutputs(boolean var1);

    @ZenMethod
    default public IMachineBuilder setSteamProgressBar(boolean highPressure, String path) {
        return this.setSteamProgressBar(highPressure, path, IMoveType.RIGHT);
    }

    @ZenMethod
    public IMachineBuilder setSteamProgressBar(boolean var1, String var2, IMoveType var3);

    @Optional.Method(modid="multiblocktweaker")
    @ModOnly(value="multiblocktweaker")
    @ZenMethod
    default public IMachineBuilder setSteamProgressBar(boolean highPressure, ITextureArea textureArea) {
        return this.setSteamProgressBar(highPressure, textureArea, IMoveType.RIGHT);
    }

    @Optional.Method(modid="multiblocktweaker")
    @ModOnly(value="multiblocktweaker")
    @ZenMethod
    public IMachineBuilder setSteamProgressBar(boolean var1, ITextureArea var2, IMoveType var3);

    @ZenMethod
    public IMachineBuilder setSteamConversionRate(boolean var1, double var2);

    @ZenMethod
    public IMachineBuilder setBoilerValues(boolean var1, int var2, @Optional(valueLong=-1L) int var3, @Optional(valueLong=-1L) int var4);

    @ZenMethod
    public IMachineBuilder setSteamTankSize(boolean var1, int var2);

    @ZenMethod
    public IMachineBuilder setSlotOverlay(boolean var1, String var2, boolean var3, @Optional boolean var4, @Optional boolean var5);

    @Optional.Method(modid="multiblocktweaker")
    @ModOnly(value="multiblocktweaker")
    @ZenMethod
    public IMachineBuilder setSlotOverlay(boolean var1, ITextureArea var2, boolean var3, @Optional boolean var4, @Optional boolean var5);

    @ZenMethod
    public void buildAndRegister();
}

