/*
 * Decompiled with CFR 0.152.
 */
package com.zook.devtech.api.unification.ore;

import com.google.common.base.CaseFormat;
import com.zook.devtech.api.unification.material.IMaterialPredicate;
import com.zook.devtech.api.unification.ore.IOreRecipeHandler;
import com.zook.devtech.common.CommonProxy;
import com.zook.devtech.common.unification.MaterialRegistry;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.items.materialitem.MetaPrefixItem;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import java.util.ArrayList;
import java.util.function.Predicate;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenMethodStatic;

@ZenExpansion(value="mods.gregtech.ore.OrePrefix")
@ZenRegister
public interface IOrePrefix {
    @ZenMethodStatic
    public static OrePrefix registerOrePrefix(String name, float amount, @Optional String iconType, @Optional long flags) {
        return MaterialRegistry.registerOrePrefix(name, amount, iconType, flags);
    }

    @ZenMethod
    public static void setGenerationPredicate(OrePrefix orePrefix, IMaterialPredicate materialPredicate) {
        orePrefix.setGenerationCondition((Predicate)materialPredicate);
    }

    @ZenMethod
    public static void generateRecipes(OrePrefix orePrefix, IOreRecipeHandler oreRegistrationHandler) {
        CommonProxy.REGISTRATION_HANDLERS.computeIfAbsent(orePrefix, key -> new ArrayList()).add(oreRegistrationHandler);
    }

    @ZenMethod
    public static void addSecondaryMaterial(OrePrefix orePrefix, Material material, @Optional(valueDouble=1.0) float amount) {
        orePrefix.addSecondaryMaterial(new MaterialStack(material, (long)(3628800.0f * amount)));
    }

    @ZenMethod
    public static void createMaterialItem(OrePrefix orePrefix) {
        MetaPrefixItem prefixItem = new MetaPrefixItem(orePrefix);
        prefixItem.setRegistryName("devtech", "meta_" + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, orePrefix.name()));
    }
}

