/*
 * Decompiled with CFR 0.152.
 */
package eutros.dynamistics.jei.categories.pauto.processing;

import eutros.dynamistics.DynamisticsJEIPlugin;
import eutros.dynamistics.jei.SingletonRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;

public abstract class PackageRecipeProvider
extends SingletonRecipe {
    public int REP_SIZE = 32;
    public int REP_X = (168 - this.REP_SIZE) / 2;
    public int REP_Y = (98 - this.REP_SIZE) / 2;
    protected IRecipeInfo recipeInfo = null;

    public PackageRecipeProvider(ItemStack stack) {
        super(stack, true);
    }

    @Nonnull
    public abstract NBTTagCompound getPackageNBT();

    public void setInfo(IRecipeInfo recipeInfo) {
        this.recipeInfo = recipeInfo;
    }

    @Override
    public void getIngredients(@Nonnull IIngredients ingredients) {
        super.getIngredients(ingredients);
        this.recipeInfo = null;
    }

    public void drawInfo(@Nonnull Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.recipeInfo == null) {
            return;
        }
        IRecipeType recipeType = this.recipeInfo.getRecipeType();
        String locName = recipeType.getLocalizedName();
        mc.field_71466_p.func_78276_b(locName, (recipeWidth - mc.field_71466_p.func_78256_a(locName)) / 2, 16, -16777216);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.REP_X, (float)this.REP_Y, (float)0.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        this.drawRep(mc, recipeType);
        GlStateManager.func_179121_F();
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.recipeInfo == null || mouseX < this.REP_X || mouseY < this.REP_Y || mouseX > this.REP_X + this.REP_SIZE || mouseY > this.REP_Y + this.REP_SIZE) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.recipeInfo.getRecipeType().getLocalizedName(), TextFormatting.GRAY + I18n.func_135052_a((String)"dynamistics.recipe.text.show_jei_categories", (Object[])new Object[0]));
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (this.recipeInfo == null || mouseButton != 0 && mouseButton != 1 || mouseX < this.REP_X || mouseY < this.REP_Y || mouseX > this.REP_X + this.REP_SIZE || mouseY > this.REP_Y + this.REP_SIZE) {
            return false;
        }
        List categories = this.recipeInfo.getRecipeType().getJEICategories();
        if (DynamisticsJEIPlugin.runtime != null && !categories.isEmpty()) {
            DynamisticsJEIPlugin.runtime.getRecipesGui().showCategories(categories);
            return true;
        }
        return false;
    }

    public void drawRep(@Nonnull Minecraft mc, IRecipeType recipeType) {
        Object rep = recipeType.getRepresentation();
        if (rep instanceof TextureAtlasSprite) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.drawTexturedModalRect((TextureAtlasSprite)rep);
        }
        if (rep instanceof ItemStack) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_175599_af().func_175042_a((ItemStack)rep, 0, 0);
            RenderHelper.func_74518_a();
        }
    }

    public void drawTexturedModalRect(TextureAtlasSprite textureSprite) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(0.0, 16.0, 0.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b(16.0, 16.0, 0.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b(16.0, 0.0, 0.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }
}

