/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.item.ItemRandomizerBag;

public class Mirror {
    public static List<BlockPos> findCoordinates(EntityPlayer player, BlockPos startPos) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        MirrorSettings m = ModifierSettingsManager.getModifierSettings(player).getMirrorSettings();
        if (!Mirror.isEnabled(m, startPos)) {
            return coordinates;
        }
        if (m.mirrorX) {
            Mirror.coordinateMirrorX(m, startPos, coordinates);
        }
        if (m.mirrorY) {
            Mirror.coordinateMirrorY(m, startPos, coordinates);
        }
        if (m.mirrorZ) {
            Mirror.coordinateMirrorZ(m, startPos, coordinates);
        }
        return coordinates;
    }

    private static void coordinateMirrorX(MirrorSettings m, BlockPos oldBlockPos, List<BlockPos> coordinates) {
        double x = m.position.field_72450_a + (m.position.field_72450_a - (double)oldBlockPos.func_177958_n() - 0.5);
        BlockPos newBlockPos = new BlockPos(x, (double)oldBlockPos.func_177956_o(), (double)oldBlockPos.func_177952_p());
        coordinates.add(newBlockPos);
        if (m.mirrorY) {
            Mirror.coordinateMirrorY(m, newBlockPos, coordinates);
        }
        if (m.mirrorZ) {
            Mirror.coordinateMirrorZ(m, newBlockPos, coordinates);
        }
    }

    private static void coordinateMirrorY(MirrorSettings m, BlockPos oldBlockPos, List<BlockPos> coordinates) {
        double y = m.position.field_72448_b + (m.position.field_72448_b - (double)oldBlockPos.func_177956_o() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.func_177958_n(), y, (double)oldBlockPos.func_177952_p());
        coordinates.add(newBlockPos);
        if (m.mirrorZ) {
            Mirror.coordinateMirrorZ(m, newBlockPos, coordinates);
        }
    }

    private static void coordinateMirrorZ(MirrorSettings m, BlockPos oldBlockPos, List<BlockPos> coordinates) {
        double z = m.position.field_72449_c + (m.position.field_72449_c - (double)oldBlockPos.func_177952_p() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.func_177958_n(), (double)oldBlockPos.func_177956_o(), z);
        coordinates.add(newBlockPos);
    }

    public static List<IBlockState> findBlockStates(EntityPlayer player, BlockPos startPos, IBlockState blockState, ItemStack itemStack, List<ItemStack> itemStacks) {
        ArrayList<IBlockState> blockStates = new ArrayList<IBlockState>();
        MirrorSettings m = ModifierSettingsManager.getModifierSettings(player).getMirrorSettings();
        if (!Mirror.isEnabled(m, startPos)) {
            return blockStates;
        }
        IItemHandler bagInventory = null;
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemRandomizerBag) {
            bagInventory = ItemRandomizerBag.getBagInventory(itemStack);
        }
        if (m.mirrorX) {
            Mirror.blockStateMirrorX(player, m, startPos, blockState, bagInventory, itemStack, EnumHand.MAIN_HAND, blockStates, itemStacks);
        }
        if (m.mirrorY) {
            Mirror.blockStateMirrorY(player, m, startPos, blockState, bagInventory, itemStack, EnumHand.MAIN_HAND, blockStates, itemStacks);
        }
        if (m.mirrorZ) {
            Mirror.blockStateMirrorZ(player, m, startPos, blockState, bagInventory, itemStack, EnumHand.MAIN_HAND, blockStates, itemStacks);
        }
        return blockStates;
    }

    private static void blockStateMirrorX(EntityPlayer player, MirrorSettings m, BlockPos oldBlockPos, IBlockState oldBlockState, IItemHandler bagInventory, ItemStack itemStack, EnumHand hand, List<IBlockState> blockStates, List<ItemStack> itemStacks) {
        double x = m.position.field_72450_a + (m.position.field_72450_a - (double)oldBlockPos.func_177958_n() - 0.5);
        BlockPos newBlockPos = new BlockPos(x, (double)oldBlockPos.func_177956_o(), (double)oldBlockPos.func_177952_p());
        if (bagInventory != null) {
            itemStack = ItemRandomizerBag.pickRandomStack(bagInventory);
            oldBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, oldBlockPos, EnumFacing.UP, new Vec3d(0.0, 0.0, 0.0), hand);
        }
        IBlockState newBlockState = oldBlockState == null ? null : oldBlockState.func_185902_a(net.minecraft.util.Mirror.FRONT_BACK);
        blockStates.add(newBlockState);
        itemStacks.add(itemStack);
        if (m.mirrorY) {
            Mirror.blockStateMirrorY(player, m, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
        if (m.mirrorZ) {
            Mirror.blockStateMirrorZ(player, m, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
    }

    private static void blockStateMirrorY(EntityPlayer player, MirrorSettings m, BlockPos oldBlockPos, IBlockState oldBlockState, IItemHandler bagInventory, ItemStack itemStack, EnumHand hand, List<IBlockState> blockStates, List<ItemStack> itemStacks) {
        double y = m.position.field_72448_b + (m.position.field_72448_b - (double)oldBlockPos.func_177956_o() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.func_177958_n(), y, (double)oldBlockPos.func_177952_p());
        if (bagInventory != null) {
            itemStack = ItemRandomizerBag.pickRandomStack(bagInventory);
            oldBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, oldBlockPos, EnumFacing.UP, new Vec3d(0.0, 0.0, 0.0), hand);
        }
        IBlockState newBlockState = oldBlockState == null ? null : Mirror.getVerticalMirror(oldBlockState);
        blockStates.add(newBlockState);
        itemStacks.add(itemStack);
        if (m.mirrorZ) {
            Mirror.blockStateMirrorZ(player, m, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
    }

    private static void blockStateMirrorZ(EntityPlayer player, MirrorSettings m, BlockPos oldBlockPos, IBlockState oldBlockState, IItemHandler bagInventory, ItemStack itemStack, EnumHand hand, List<IBlockState> blockStates, List<ItemStack> itemStacks) {
        double z = m.position.field_72449_c + (m.position.field_72449_c - (double)oldBlockPos.func_177952_p() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.func_177958_n(), (double)oldBlockPos.func_177956_o(), z);
        if (bagInventory != null) {
            itemStack = ItemRandomizerBag.pickRandomStack(bagInventory);
            oldBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, oldBlockPos, EnumFacing.UP, new Vec3d(0.0, 0.0, 0.0), hand);
        }
        IBlockState newBlockState = oldBlockState == null ? null : oldBlockState.func_185902_a(net.minecraft.util.Mirror.LEFT_RIGHT);
        blockStates.add(newBlockState);
        itemStacks.add(itemStack);
    }

    public static boolean isEnabled(MirrorSettings m, BlockPos startPos) {
        if (m == null || !m.enabled || !m.mirrorX && !m.mirrorY && !m.mirrorZ) {
            return false;
        }
        return !((double)startPos.func_177958_n() + 0.5 < m.position.field_72450_a - (double)m.radius || (double)startPos.func_177958_n() + 0.5 > m.position.field_72450_a + (double)m.radius || (double)startPos.func_177956_o() + 0.5 < m.position.field_72448_b - (double)m.radius || (double)startPos.func_177956_o() + 0.5 > m.position.field_72448_b + (double)m.radius || (double)startPos.func_177952_p() + 0.5 < m.position.field_72449_c - (double)m.radius) && !((double)startPos.func_177952_p() + 0.5 > m.position.field_72449_c + (double)m.radius);
    }

    private static IBlockState getVerticalMirror(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockStairs) {
            if (blockState.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.BOTTOM) {
                return blockState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            return blockState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM);
        }
        if (blockState.func_177230_c() instanceof BlockSlab) {
            if (((BlockSlab)blockState.func_177230_c()).func_176552_j()) {
                return blockState;
            }
            if (blockState.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM) {
                return blockState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
            }
            return blockState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        if (blockState.func_177230_c() instanceof BlockDirectional) {
            if (blockState.func_177229_b((IProperty)BlockDirectional.field_176387_N) == EnumFacing.DOWN) {
                return blockState.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.UP);
            }
            if (blockState.func_177229_b((IProperty)BlockDirectional.field_176387_N) == EnumFacing.UP) {
                return blockState.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.DOWN);
            }
        }
        if (blockState.func_177230_c() instanceof BlockDispenser) {
            if (blockState.func_177229_b((IProperty)BlockDispenser.field_176441_a) == EnumFacing.DOWN) {
                return blockState.func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)EnumFacing.UP);
            }
            if (blockState.func_177229_b((IProperty)BlockDispenser.field_176441_a) == EnumFacing.UP) {
                return blockState.func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)EnumFacing.DOWN);
            }
        }
        return blockState;
    }

    public static class MirrorSettings {
        public boolean enabled = false;
        public Vec3d position = new Vec3d(0.5, 64.5, 0.5);
        public boolean mirrorX = true;
        public boolean mirrorY = false;
        public boolean mirrorZ = false;
        public int radius = 10;
        public boolean drawLines = true;
        public boolean drawPlanes = true;

        public MirrorSettings() {
        }

        public MirrorSettings(boolean mirrorEnabled, Vec3d position, boolean mirrorX, boolean mirrorY, boolean mirrorZ, int radius, boolean drawLines, boolean drawPlanes) {
            this.enabled = mirrorEnabled;
            this.position = position;
            this.mirrorX = mirrorX;
            this.mirrorY = mirrorY;
            this.mirrorZ = mirrorZ;
            this.radius = radius;
            this.drawLines = drawLines;
            this.drawPlanes = drawPlanes;
        }

        public int getReach() {
            return this.radius * 2;
        }
    }
}

