/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;

@Mod.EventBusSubscriber
public class ModeCapabilityManager {
    @CapabilityInject(value=IModeCapability.class)
    public static final Capability<IModeCapability> modeCapability = null;

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        IModeCapability original = (IModeCapability)event.getOriginal().getCapability(modeCapability, null);
        IModeCapability clone = (IModeCapability)event.getEntity().getCapability(modeCapability, null);
        clone.setModeData(original.getModeData());
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        IModeCapability inst = (IModeCapability)modeCapability.getDefaultInstance();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == modeCapability;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == modeCapability) {
                return (T)modeCapability.cast((Object)this.inst);
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return modeCapability.getStorage().writeNBT(modeCapability, (Object)this.inst, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            modeCapability.getStorage().readNBT(modeCapability, (Object)this.inst, null, nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<IModeCapability> {
        public NBTBase writeNBT(Capability<IModeCapability> capability, IModeCapability instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            ModeSettingsManager.ModeSettings modeSettings = instance.getModeData();
            if (modeSettings == null) {
                modeSettings = new ModeSettingsManager.ModeSettings();
            }
            return compound;
        }

        public void readNBT(Capability<IModeCapability> capability, IModeCapability instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            ModeSettingsManager.ModeSettings modeSettings = new ModeSettingsManager.ModeSettings(BuildModes.BuildModeEnum.NORMAL);
            instance.setModeData(modeSettings);
        }
    }

    public static class ModeCapability
    implements IModeCapability {
        private ModeSettingsManager.ModeSettings modeSettings;

        @Override
        public ModeSettingsManager.ModeSettings getModeData() {
            return this.modeSettings;
        }

        @Override
        public void setModeData(ModeSettingsManager.ModeSettings modeSettings) {
            this.modeSettings = modeSettings;
        }
    }

    public static interface IModeCapability {
        public ModeSettingsManager.ModeSettings getModeData();

        public void setModeData(ModeSettingsManager.ModeSettings var1);
    }
}

