/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;

public class ModeSettingsMessage
implements IMessage {
    private ModeSettingsManager.ModeSettings modeSettings;

    public ModeSettingsMessage() {
    }

    public ModeSettingsMessage(ModeSettingsManager.ModeSettings modeSettings) {
        this.modeSettings = modeSettings;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.modeSettings.getBuildMode().ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        BuildModes.BuildModeEnum buildMode = BuildModes.BuildModeEnum.values()[buf.readInt()];
        this.modeSettings = new ModeSettingsManager.ModeSettings(buildMode);
    }

    public static class MessageHandler
    implements IMessageHandler<ModeSettingsMessage, IMessage> {
        public IMessage onMessage(ModeSettingsMessage message, MessageContext ctx) {
            ModeSettingsManager.ModeSettings modeSettings = message.modeSettings;
            IThreadListener threadListener = EffortlessBuilding.proxy.getThreadListenerFromContext(ctx);
            threadListener.func_152344_a(() -> {
                EntityPlayer player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                ModeSettingsManager.sanitize(modeSettings, player);
                ModeSettingsManager.setModeSettings(player, modeSettings);
            });
            return null;
        }
    }
}

