/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api;

import com.google.common.collect.Lists;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.advancement.IAdvancementManager;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.command.ICommandManager;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.gui.UIFactory;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.modules.IModuleManager;
import gregtech.api.network.INetworkHandler;
import gregtech.api.sound.ISoundManager;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.util.BaseCreativeTab;
import gregtech.api.util.GTControlledRegistry;
import gregtech.api.util.GTLog;
import gregtech.api.util.IBlockOre;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.GenericEvent;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

public class GregTechAPI {
    public static Object instance;
    public static IModuleManager moduleManager;
    public static INetworkHandler networkHandler;
    public static ICommandManager commandManager;
    public static IAdvancementManager advancementManager;
    public static ISoundManager soundManager;
    public static final GTControlledRegistry<ResourceLocation, MetaTileEntity> MTE_REGISTRY;
    public static final GTControlledRegistry<ResourceLocation, UIFactory> UI_FACTORY_REGISTRY;
    public static final GTControlledRegistry<ResourceLocation, CoverDefinition> COVER_REGISTRY;
    public static final MaterialRegistry MATERIAL_REGISTRY;
    public static BlockMachine MACHINE;
    public static final Map<Material, Map<StoneType, IBlockOre>> oreBlockTable;
    public static final Object2ObjectOpenHashMap<IBlockState, IHeatingCoilBlockStats> HEATING_COILS;
    public static final BaseCreativeTab TAB_GREGTECH;
    public static final BaseCreativeTab TAB_GREGTECH_MATERIALS;
    public static final BaseCreativeTab TAB_GREGTECH_ORES;

    static {
        MTE_REGISTRY = new GTControlledRegistry(Short.MAX_VALUE);
        UI_FACTORY_REGISTRY = new GTControlledRegistry(Short.MAX_VALUE);
        COVER_REGISTRY = new GTControlledRegistry(Integer.MAX_VALUE);
        MATERIAL_REGISTRY = new MaterialRegistry();
        oreBlockTable = new HashMap<Material, Map<StoneType, IBlockOre>>();
        HEATING_COILS = new Object2ObjectOpenHashMap();
        TAB_GREGTECH = new BaseCreativeTab("gregtech.main", () -> MetaItems.BATTERY_HULL_HV.getStackForm(), true);
        TAB_GREGTECH_MATERIALS = new BaseCreativeTab("gregtech.materials", () -> OreDictUnifier.get(OrePrefix.ingot, Materials.Aluminium), true);
        TAB_GREGTECH_ORES = new BaseCreativeTab("gregtech.ores", () -> ToolItems.DRILL_MV.get(Materials.Aluminium), true);
    }

    @ZenClass(value="mods.gregtech.material.MaterialRegistry")
    @ZenRegister
    public static class MaterialRegistry
    extends GTControlledRegistry<String, Material> {
        private boolean isRegistryClosed = false;

        private MaterialRegistry() {
            super(Short.MAX_VALUE);
        }

        public void register(Material value) {
            this.register(value.getId(), value.toString(), value);
        }

        @Override
        public void register(int id, String key, Material value) {
            if (this.isRegistryClosed) {
                GTLog.logger.error("Materials cannot be registered in the PostMaterialEvent! Must be added in the MaterialEvent. Skipping material {}...", (Object)key);
                return;
            }
            super.register(id, key, value);
        }

        public void closeRegistry() {
            this.isRegistryClosed = true;
        }

        @ZenMethod
        @Nullable
        public static Material get(String name) {
            return (Material)MATERIAL_REGISTRY.func_82594_a(name);
        }

        @ZenMethod
        public static List<Material> getAllMaterials() {
            return Lists.newArrayList((Iterable)((Object)MATERIAL_REGISTRY));
        }
    }

    public static class PostMaterialEvent
    extends GenericEvent<Material> {
        public PostMaterialEvent() {
            super(Material.class);
        }
    }

    public static class MaterialEvent
    extends GenericEvent<Material> {
        public MaterialEvent() {
            super(Material.class);
        }
    }

    public static class RegisterEvent<V>
    extends GenericEvent<V> {
        private final GTControlledRegistry<ResourceLocation, V> registry;

        public RegisterEvent(GTControlledRegistry<ResourceLocation, V> registry, Class<V> clazz) {
            super(clazz);
            this.registry = registry;
        }

        public void register(int id, ResourceLocation key, V value) {
            if (this.registry != null) {
                this.registry.register(id, key, value);
            }
        }

        public void register(int id, String key, V value) {
            if (this.registry != null) {
                this.registry.register(id, new ResourceLocation(Loader.instance().activeModContainer().getModId(), key), value);
            }
        }
    }
}

