/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

import gregtech.api.fluids.MaterialFluid;
import gregtech.api.fluids.fluidType.FluidType;
import gregtech.api.fluids.fluidType.FluidTypes;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public interface IThermalFluidHandlerItemStack {
    default public boolean canFillFluidType(FluidStack stack) {
        if (stack == null || stack.getFluid() == null) {
            return false;
        }
        Fluid fluid = stack.getFluid();
        if (fluid.getTemperature() > this.getMaxFluidTemperature()) {
            return false;
        }
        if (fluid.getTemperature() < 120 && !this.isCryoProof()) {
            return false;
        }
        if (fluid.isGaseous() && !this.isGasProof()) {
            return false;
        }
        if (fluid instanceof MaterialFluid) {
            FluidType fluidType = ((MaterialFluid)fluid).getFluidType();
            if (fluidType == FluidTypes.ACID && !this.isAcidProof()) {
                return false;
            }
            if (fluidType == FluidTypes.PLASMA && !this.isPlasmaProof()) {
                return false;
            }
        }
        return true;
    }

    public int getMaxFluidTemperature();

    public boolean isGasProof();

    public boolean isAcidProof();

    public boolean isCryoProof();

    public boolean isPlasmaProof();
}

