/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import gregtech.api.GregTechAPI;
import gregtech.api.fluids.GTFluidMaterial;
import gregtech.api.fluids.MaterialFluid;
import gregtech.api.fluids.MaterialFluidBlock;
import gregtech.api.fluids.fluidType.FluidType;
import gregtech.api.fluids.fluidType.FluidTypes;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.PlasmaProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.LocalizationUtils;
import gregtech.common.blocks.MetaBlocks;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class MetaFluids {
    private static final Set<ResourceLocation> fluidSprites = new ObjectOpenHashSet();
    private static final Map<String, Material> fluidToMaterialMappings = new Object2ObjectOpenHashMap();
    private static final Map<String, String> alternativeFluidNames = new Object2ObjectOpenHashMap();
    private static final Table<Material, FluidType, ResourceLocation> fluidTextures = HashBasedTable.create();
    public static final ResourceLocation AUTO_GENERATED_PLASMA_TEXTURE = new ResourceLocation("gregtech", "blocks/fluids/fluid.plasma.autogenerated");

    public static void registerSprites(TextureMap textureMap) {
        for (ResourceLocation spriteLocation : fluidSprites) {
            textureMap.func_174942_a(spriteLocation);
        }
    }

    public static void init() {
        MetaFluids.handleNonMaterialFluids(Materials.Water, FluidRegistry.WATER);
        MetaFluids.handleNonMaterialFluids(Materials.Lava, FluidRegistry.LAVA);
        MetaFluids.addAlternativeNames();
        MetaFluids.setCustomTextures();
        Iterator iterator = GregTechAPI.MATERIAL_REGISTRY.iterator();
        while (iterator.hasNext()) {
            PlasmaProperty plasmaProperty;
            Material material = (Material)iterator.next();
            FluidProperty fluidProperty = material.getProperty(PropertyKey.FLUID);
            if (fluidProperty != null && fluidProperty.getFluid() == null) {
                int temperature = Math.max(material.getBlastTemperature(), fluidProperty.getFluidTemperature());
                Fluid fluid = MetaFluids.registerFluid(material, fluidProperty.getFluidType(), temperature, fluidProperty.hasBlock());
                fluidProperty.setFluid(fluid);
                fluidProperty.setFluidTemperature(fluid.getTemperature(), fluid.getTemperature() >= 0);
            }
            if ((plasmaProperty = material.getProperty(PropertyKey.PLASMA)) == null || plasmaProperty.getPlasma() != null) continue;
            int temperature = (fluidProperty == null ? 0 : fluidProperty.getFluidTemperature()) + 10000;
            Fluid fluid = MetaFluids.registerFluid(material, FluidTypes.PLASMA, temperature, false);
            plasmaProperty.setPlasma(fluid);
        }
    }

    public static void handleNonMaterialFluids(@Nonnull Material material, @Nonnull Fluid fluid) {
        material.getProperty(PropertyKey.FLUID).setFluid(fluid);
        material.getProperty(PropertyKey.FLUID).setFluidTemperature(fluid.getTemperature());
        ArrayList<String> tooltip = new ArrayList<String>();
        if (!material.getChemicalFormula().isEmpty()) {
            tooltip.add(TextFormatting.YELLOW + material.getChemicalFormula());
        }
        tooltip.add(LocalizationUtils.format("gregtech.fluid.temperature", material.getProperty(PropertyKey.FLUID).getFluidTemperature()));
        tooltip.add(LocalizationUtils.format(material.getProperty(PropertyKey.FLUID).getFluidType().getUnlocalizedTooltip(), new Object[0]));
        tooltip.addAll(material.getProperty(PropertyKey.FLUID).getFluidType().getAdditionalTooltips());
        FluidTooltipUtil.registerTooltip(fluid, tooltip);
    }

    private static void addAlternativeNames() {
        MetaFluids.setAlternativeFluidName(Materials.Ethanol, FluidTypes.LIQUID, "bio.ethanol");
        MetaFluids.setAlternativeFluidName(Materials.SeedOil, FluidTypes.LIQUID, "seed.oil");
        MetaFluids.setAlternativeFluidName(Materials.Ice, FluidTypes.LIQUID, "fluid.ice");
        MetaFluids.setAlternativeFluidName(Materials.Diesel, FluidTypes.LIQUID, "fuel");
    }

    private static void setCustomTextures() {
        MetaFluids.setMaterialFluidTexture(Materials.Air, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.Deuterium, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.Tritium, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.Helium, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.Helium, FluidTypes.PLASMA);
        MetaFluids.setMaterialFluidTexture(Materials.Helium3, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.Fluorine, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.TitaniumTetrachloride, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Steam, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.OilHeavy, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.RawOil, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.OilLight, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.HydrogenSulfide, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.SulfuricGas, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.RefineryGas, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.SulfuricNaphtha, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.SulfuricLightFuel, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.SulfuricHeavyFuel, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Naphtha, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.LightFuel, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.HeavyFuel, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.LPG, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.LightlySteamCrackedLightFuel, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.SeverelySteamCrackedLightFuel, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.LightlySteamCrackedHeavyFuel, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.SeverelySteamCrackedHeavyFuel, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Chlorine, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.CetaneBoostedDiesel, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.SodiumPersulfate, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.GlycerylTrinitrate, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Lubricant, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Creosote, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.SeedOil, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Oil, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Diesel, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Biomass, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Ethanol, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.SulfuricAcid, FluidTypes.ACID);
        MetaFluids.setMaterialFluidTexture(Materials.Milk, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.McGuffium239, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Glue, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.HydrochloricAcid, FluidTypes.ACID);
        MetaFluids.setMaterialFluidTexture(Materials.LeadZincSolution, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.NaturalGas, FluidTypes.GAS);
        MetaFluids.setMaterialFluidTexture(Materials.Blaze, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.FluoroantimonicAcid, FluidTypes.ACID);
        MetaFluids.setMaterialFluidTexture(Materials.Naquadah, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.NaquadahEnriched, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Naquadria, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.Ice, FluidTypes.LIQUID);
        MetaFluids.setMaterialFluidTexture(Materials.UUMatter, FluidTypes.LIQUID);
    }

    public static void initIconFluidSprites() {
        fluidSprites.add(AUTO_GENERATED_PLASMA_TEXTURE);
        for (MaterialIconSet materialIconSet : MaterialIconSet.ICON_SETS.values()) {
            fluidSprites.add(MaterialIconType.fluid.getBlockTexturePath(materialIconSet));
        }
    }

    public static void setMaterialFluidTexture(@Nonnull Material material, @Nonnull FluidType fluidType) {
        String path = "blocks/fluids/fluid." + material.toString();
        if (fluidType.equals(FluidTypes.PLASMA)) {
            path = path + ".plasma";
        }
        ResourceLocation resourceLocation = new ResourceLocation("gregtech", path);
        MetaFluids.setMaterialFluidTexture(material, fluidType, resourceLocation);
    }

    public static void setMaterialFluidTexture(Material material, FluidType fluidType, ResourceLocation textureLocation) {
        if (!fluidTextures.contains((Object)material, (Object)fluidType)) {
            fluidTextures.put((Object)material, (Object)fluidType, (Object)textureLocation);
        }
        fluidSprites.add(textureLocation);
    }

    public static void setAlternativeFluidName(Material material, @Nonnull FluidType fluidType, String alternativeName) {
        alternativeFluidNames.put(fluidType.getNameForMaterial(material), alternativeName);
    }

    @Nonnull
    public static Fluid registerFluid(@Nonnull Material material, @Nonnull FluidType fluidType, int temperature, boolean generateBlock) {
        String materialName = material.toString();
        String fluidName = fluidType.getNameForMaterial(material);
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null && alternativeFluidNames.containsKey(fluidName)) {
            String altName = alternativeFluidNames.get(fluidName);
            fluid = FluidRegistry.getFluid((String)altName);
        }
        if (fluid == null) {
            if (!fluidTextures.contains((Object)material, (Object)fluidType)) {
                if (fluidType.equals(FluidTypes.PLASMA)) {
                    fluidTextures.put((Object)material, (Object)fluidType, (Object)AUTO_GENERATED_PLASMA_TEXTURE);
                } else {
                    fluidTextures.put((Object)material, (Object)fluidType, (Object)MaterialIconType.fluid.getBlockTexturePath(material.getMaterialIconSet()));
                }
            }
            ResourceLocation textureLocation = (ResourceLocation)fluidTextures.get((Object)material, (Object)fluidType);
            fluid = new MaterialFluid(fluidName, material, fluidType, textureLocation);
            fluid.setTemperature(temperature);
            fluid.setDensity((int)(material.getMass() * 100L));
            if (material.hasFluidColor()) {
                fluid.setColor(GTUtility.convertRGBtoOpaqueRGBA_MC(material.getMaterialRGB()));
            } else {
                fluid.setColor(-1);
            }
            FluidType.setFluidProperties(fluidType, fluid);
            if (material.hasFlag(MaterialFlags.STICKY)) {
                fluid.setViscosity(2000);
            }
            ((MaterialFluid)fluid).registerFluidTooltip();
            FluidRegistry.registerFluid((Fluid)fluid);
        }
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        if (generateBlock && fluid.getBlock() == null && fluidType != FluidTypes.PLASMA) {
            GTFluidMaterial fluidMaterial = new GTFluidMaterial(GTUtility.getMapColor(material.getMaterialRGB()), material.hasFlag(MaterialFlags.STICKY));
            MaterialFluidBlock fluidBlock = new MaterialFluidBlock(fluid, fluidMaterial, material);
            fluidBlock.setRegistryName("fluid." + materialName);
            MetaBlocks.FLUID_BLOCKS.add((BlockFluidBase)fluidBlock);
        }
        fluidToMaterialMappings.put(fluid.getName(), material);
        return fluid;
    }

    @Nullable
    public static Material getMaterialFromFluid(@Nonnull Fluid fluid) {
        Material material = fluidToMaterialMappings.get(fluid.getName());
        if (material.hasFluid()) {
            return material;
        }
        return null;
    }
}

