/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ImageWidget
extends Widget {
    protected IGuiTexture area;
    private BooleanSupplier predicate;
    private boolean isVisible = true;
    private int border;
    private int borderColor;
    private String tooltipText;
    private boolean ignoreColor = false;

    public ImageWidget(int xPosition, int yPosition, int width, int height) {
        super(new Position(xPosition, yPosition), new Size(width, height));
    }

    public ImageWidget(int xPosition, int yPosition, int width, int height, IGuiTexture area) {
        this(xPosition, yPosition, width, height);
        this.area = area;
    }

    public ImageWidget setImage(TextureArea area) {
        this.area = area;
        return this;
    }

    public ImageWidget setBorder(int border, int color) {
        this.border = border;
        this.borderColor = color;
        return this;
    }

    public ImageWidget setPredicate(BooleanSupplier predicate) {
        this.predicate = predicate;
        this.isVisible = false;
        return this;
    }

    public ImageWidget setTooltip(String tooltipText) {
        this.tooltipText = tooltipText;
        return this;
    }

    public ImageWidget setIgnoreColor(boolean ignore) {
        this.ignoreColor = ignore;
        return this;
    }

    @Override
    public void updateScreen() {
        if (this.area != null) {
            this.area.updateTick();
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.predicate != null && this.predicate.getAsBoolean() != this.isVisible) {
            this.isVisible = this.predicate.getAsBoolean();
            this.writeUpdateInfo(1, buf -> buf.writeBoolean(this.isVisible));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.isVisible = buffer.readBoolean();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (!this.isVisible || this.area == null) {
            return;
        }
        if (this.ignoreColor) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        Position position = this.getPosition();
        Size size = this.getSize();
        this.area.draw(position.x, position.y, size.width, size.height);
        if (this.border > 0) {
            ImageWidget.drawBorder(position.x, position.y, size.width, size.height, this.borderColor, this.border);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isVisible && this.tooltipText != null && this.area != null && this.isMouseOverElement(mouseX, mouseY)) {
            List<String> hoverList = Arrays.asList(I18n.func_135052_a((String)this.tooltipText, (Object[])new Object[0]).split("/n"));
            this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
        }
    }
}

