/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.collect.Lists;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.ingredient.IGhostIngredientTarget;
import gregtech.api.util.Position;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OreDictFilterTestSlot
extends Widget
implements IGhostIngredientTarget {
    private ItemStack testStack = ItemStack.field_190927_a;
    private Consumer<ItemStack> listener;

    public OreDictFilterTestSlot(int xPosition, int yPosition) {
        super(xPosition, yPosition, 18, 18);
    }

    public OreDictFilterTestSlot setListener(Consumer<ItemStack> listener) {
        this.listener = listener;
        return this;
    }

    public OreDictFilterTestSlot setTestStack(ItemStack testStack) {
        if (testStack != null) {
            this.testStack = testStack;
        }
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack cursorStack = player.field_71071_by.func_70445_o();
            this.putItem(cursorStack);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void putItem(ItemStack stack) {
        if (stack.func_190926_b() ^ this.testStack.func_190926_b() || !this.testStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)this.testStack, (ItemStack)stack)) {
            this.testStack = stack.func_77946_l();
            this.testStack.func_190920_e(1);
            if (this.listener != null) {
                this.listener.accept(this.testStack);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        Position pos = this.getPosition();
        GuiTextures.SLOT.draw(pos.x, pos.y, 18, 18);
        if (!this.testStack.func_190926_b()) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179126_j();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
            RenderHelper.func_74518_a();
            RenderHelper.func_74519_b();
            RenderHelper.func_74520_c();
            GlStateManager.func_179094_E();
            RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
            itemRender.func_180450_b(this.testStack, pos.x + 1, pos.y + 1);
            itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, this.testStack, pos.x + 1, pos.y + 1, null);
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
        }
        if (this.isActive() && this.isMouseOverElement(mouseX, mouseY)) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            OreDictFilterTestSlot.drawSolidRect(this.getPosition().x + 1, this.getPosition().y + 1, 16, 16, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isActive() && this.isMouseOverElement(mouseX, mouseY)) {
            if (!this.testStack.func_190926_b()) {
                GuiUtils.preItemToolTip((ItemStack)this.testStack);
                this.drawHoveringText(this.testStack, OreDictFilterTestSlot.getItemToolTip(this.testStack), 300, mouseX, mouseY);
                GuiUtils.postItemToolTip();
            } else {
                this.drawHoveringText(ItemStack.field_190927_a, Arrays.asList(I18n.func_135052_a((String)"cover.ore_dictionary_filter.test_slot.info", (Object[])new Object[0]).split("/n")), 300, mouseX, mouseY);
            }
        }
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @Nonnull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    OreDictFilterTestSlot.this.putItem((ItemStack)ingredient);
                }
            }
        }});
    }
}

