/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.collect.Lists;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ingredient.IGhostIngredientTarget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.client.utils.RenderUtil;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class PhantomTankWidget
extends TankWidget
implements IGhostIngredientTarget {
    private final FluidTank phantomTank;
    protected FluidStack lastPhantomStack;

    public PhantomTankWidget(IFluidTank fluidTank, int x, int y, int width, int height, FluidTank phantomTank) {
        super(fluidTank, x, y, width, height);
        this.phantomTank = phantomTank;
    }

    @Override
    public PhantomTankWidget setClient() {
        super.setClient();
        this.lastPhantomStack = this.phantomTank != null ? (this.phantomTank.getFluid() != null ? this.phantomTank.getFluid().copy() : null) : null;
        return this;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (this.lastFluidInTank != null || !(ingredient instanceof FluidStack) && this.drainFrom(ingredient) == null) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @Nonnull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                FluidStack stack = ingredient instanceof FluidStack ? (FluidStack)ingredient : PhantomTankWidget.this.drainFrom(ingredient);
                if (stack != null) {
                    NBTTagCompound compound = stack.writeToNBT(new NBTTagCompound());
                    PhantomTankWidget.this.writeClientAction(13, buf -> buf.func_150786_a(compound));
                }
                if (PhantomTankWidget.this.isClient) {
                    PhantomTankWidget.this.phantomTank.setFluid(stack);
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buf) {
        super.handleClientAction(id, buf);
        if (id == 12) {
            ItemStack stack = this.gui.entityPlayer.field_71071_by.func_70445_o().func_77946_l();
            if (!stack.func_190926_b()) {
                stack.func_190920_e(1);
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fluidHandler != null) {
                    FluidStack resultStack = fluidHandler.drain(Integer.MAX_VALUE, false);
                    this.phantomTank.setFluid(resultStack);
                }
            } else {
                this.phantomTank.setFluid(null);
            }
        } else if (id == 13) {
            FluidStack stack;
            try {
                stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buf.func_150793_b());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.phantomTank.setFluid(stack);
        }
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            return this.lastFluidInTank == null ? this.lastPhantomStack : this.lastFluidInTank;
        }
        return null;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.writeClientAction(12, buf -> {});
            if (this.isClient) {
                this.phantomTank.setFluid(null);
            }
            return true;
        }
        return false;
    }

    private FluidStack drainFrom(Object ingredient) {
        ItemStack itemStack;
        IFluidHandlerItem fluidHandler;
        if (ingredient instanceof ItemStack && (fluidHandler = (IFluidHandlerItem)(itemStack = (ItemStack)ingredient).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            return fluidHandler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.lastFluidInTank != null) {
            super.drawInBackground(mouseX, mouseY, partialTicks, context);
            return;
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.lastPhantomStack != null && !this.gui.isJEIHandled) {
            GlStateManager.func_179084_k();
            FluidStack stackToDraw = this.lastPhantomStack;
            if (stackToDraw.amount == 0) {
                stackToDraw = GTUtility.copyAmount(1, stackToDraw);
            }
            RenderUtil.drawFluidForGui(stackToDraw, 1, pos.x + this.fluidRenderOffset, pos.y + this.fluidRenderOffset, size.width - this.fluidRenderOffset, size.height - this.fluidRenderOffset);
            GlStateManager.func_179147_l();
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.lastFluidInTank == null) {
            return;
        }
        super.drawInForeground(mouseX, mouseY);
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.isClient) {
            FluidStack stack = this.phantomTank.getFluid();
            if (stack == null && this.lastPhantomStack != null) {
                this.lastPhantomStack = null;
            } else if (stack != null) {
                if (!stack.isFluidEqual(this.lastPhantomStack)) {
                    this.lastPhantomStack = stack.copy();
                } else if (stack.amount != 0) {
                    this.lastPhantomStack.amount = 0;
                }
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        FluidStack stack = this.phantomTank.getFluid();
        if (stack == null && this.lastPhantomStack != null) {
            this.lastPhantomStack = null;
            this.writeUpdateInfo(10, buf -> {});
        } else if (stack != null) {
            if (!stack.isFluidEqual(this.lastPhantomStack)) {
                this.lastPhantomStack = stack.copy();
                NBTTagCompound stackTag = stack.writeToNBT(new NBTTagCompound());
                this.writeUpdateInfo(11, buf -> buf.func_150786_a(stackTag));
            } else if (stack.amount != 0) {
                this.lastPhantomStack.amount = 0;
                this.writeUpdateInfo(12, buf -> {});
            }
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buf) {
        super.readUpdateInfo(id, buf);
        if (id == 10) {
            this.lastPhantomStack = null;
        } else if (id == 11) {
            NBTTagCompound stackTag;
            try {
                stackTag = buf.func_150793_b();
            }
            catch (IOException ignored) {
                return;
            }
            this.lastPhantomStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackTag);
        } else if (id == 12) {
            this.lastPhantomStack.amount = 0;
        }
    }

    @Override
    public String getFormattedFluidAmount() {
        if (this.lastFluidInTank == null) {
            return "0";
        }
        return super.getFormattedFluidAmount();
    }

    @Override
    public String getFluidLocalizedName() {
        if (this.lastFluidInTank == null) {
            return this.lastPhantomStack == null ? "" : this.lastPhantomStack.getLocalizedName();
        }
        return super.getFluidLocalizedName();
    }
}

