/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class SyncableColorRectWidget
extends Widget {
    protected Supplier<Integer> colorSupplier;
    protected int borderWidth;
    protected int borderColor;
    protected boolean drawCheckerboard;
    protected int checkerboardGridRows;
    protected int checkerboardGridColumns;
    private int color;

    public SyncableColorRectWidget(int x, int y, int width, int height, Supplier<Integer> colorSupplier) {
        super(x, y, width, height);
        this.colorSupplier = colorSupplier;
        this.borderWidth = 0;
        this.drawCheckerboard = false;
        this.checkerboardGridRows = 1;
        this.checkerboardGridColumns = 1;
        this.borderColor = -16777216;
    }

    public SyncableColorRectWidget setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public SyncableColorRectWidget setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public SyncableColorRectWidget drawCheckerboard(int checkerboardGridColumns, int checkerboardGridRows) {
        this.drawCheckerboard = true;
        this.checkerboardGridColumns = checkerboardGridColumns;
        this.checkerboardGridRows = checkerboardGridRows;
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        Position position = this.getPosition();
        Size size = this.getSize();
        SyncableColorRectWidget.drawSolidRect(position.x, position.y, size.width, size.height, this.borderColor);
        if (this.drawCheckerboard) {
            int white = -1;
            int grey = -4210753;
            int columnWidth = (size.width - 2 * this.borderWidth) / this.checkerboardGridColumns;
            int rowHeight = (size.height - 2 * this.borderWidth) / this.checkerboardGridRows;
            boolean whiteGrey = false;
            for (int i = 0; i < this.checkerboardGridRows; ++i) {
                for (int j = 0; j < this.checkerboardGridColumns; ++j) {
                    SyncableColorRectWidget.drawSolidRect(position.x + this.borderWidth + i * columnWidth, position.y + this.borderWidth + j * rowHeight, columnWidth, rowHeight, whiteGrey ? white : grey);
                    whiteGrey = !whiteGrey;
                }
                whiteGrey = !whiteGrey;
            }
        }
        SyncableColorRectWidget.drawSolidRect(position.x + this.borderWidth, position.y + this.borderWidth, size.width - 2 * this.borderWidth, size.height - 2 * this.borderWidth, this.color);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.colorSupplier != null && this.colorSupplier.get() != this.color) {
            this.color = this.colorSupplier.get();
            this.writeUpdateInfo(1, buffer -> buffer.writeInt(this.color));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.color = buffer.readInt();
        }
    }
}

