/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.armor;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.util.ItemStackKey;
import gregtech.common.ConfigHolder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ArmorUtils {
    public static final Side SIDE = FMLCommonHandler.instance().getSide();
    public static final SoundEvent JET_ENGINE = new SoundEvent(new ResourceLocation("gregtech:jet_engine"));

    public static boolean isPossibleToCharge(ItemStack chargeable) {
        IElectricItem container = (IElectricItem)chargeable.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (container != null) {
            return container.getCharge() < container.getMaxCharge() && container.getCharge() + container.getTransferLimit() <= container.getMaxCharge();
        }
        return false;
    }

    public static List<Pair<NonNullList<ItemStack>, List<Integer>>> getChargeableItem(EntityPlayer player, int tier) {
        ItemStack offHand;
        IElectricItem offHandItem;
        ArrayList<Pair<NonNullList<ItemStack>, List<Integer>>> inventorySlotMap = new ArrayList<Pair<NonNullList<ItemStack>, List<Integer>>>();
        ArrayList<Integer> openMainSlots = new ArrayList<Integer>();
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack current = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            IElectricItem item = (IElectricItem)current.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (item == null || !ArmorUtils.isPossibleToCharge(current) || item.getTier() > tier) continue;
            openMainSlots.add(i);
        }
        if (!openMainSlots.isEmpty()) {
            inventorySlotMap.add(Pair.of((Object)player.field_71071_by.field_70462_a, openMainSlots));
        }
        ArrayList<Integer> openArmorSlots = new ArrayList<Integer>();
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            ItemStack current = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            IElectricItem item = (IElectricItem)current.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (item == null || !ArmorUtils.isPossibleToCharge(current) || item.getTier() > tier) continue;
            openArmorSlots.add(i);
        }
        if (!openArmorSlots.isEmpty()) {
            inventorySlotMap.add(Pair.of((Object)player.field_71071_by.field_70460_b, openArmorSlots));
        }
        if ((offHandItem = (IElectricItem)(offHand = (ItemStack)player.field_71071_by.field_184439_c.get(0)).getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) == null) {
            return inventorySlotMap;
        }
        if (ArmorUtils.isPossibleToCharge(offHand) && offHandItem.getTier() <= tier) {
            inventorySlotMap.add((Pair<NonNullList<ItemStack>, List<Integer>>)Pair.of((Object)player.field_71071_by.field_184439_c, Collections.singletonList(0)));
        }
        return inventorySlotMap;
    }

    public static void spawnParticle(World world, EntityPlayer player, EnumParticleTypes type, double speedY) {
        if (type != null && SIDE.isClient()) {
            Vec3d forward = player.func_189651_aD();
            world.func_175688_a(type, player.field_70165_t - forward.field_72450_a, player.field_70163_u + 0.5, player.field_70161_v - forward.field_72449_c, 0.0, speedY, 0.0, new int[0]);
        }
    }

    public static void playJetpackSound(@Nonnull EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            float cons = (float)player.field_70181_x + player.field_191988_bg;
            cons = MathHelper.func_76131_a((float)cons, (float)0.6f, (float)1.0f);
            if (player.field_70181_x > (double)0.05f) {
                cons += 0.1f;
            }
            if (player.field_70181_x < (double)-0.05f) {
                cons -= 0.4f;
            }
            player.func_184185_a(JET_ENGINE, 0.3f, cons);
        }
    }

    public static void resetPlayerFloatingTime(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ObfuscationReflectionHelper.setPrivateValue(NetHandlerPlayServer.class, (Object)((EntityPlayerMP)player).field_71135_a, (Object)0, (String[])new String[]{"field_147365_f", "floatingTickCount"});
        }
    }

    public static ActionResult<ItemStack> canEat(EntityPlayer player, ItemStack food) {
        if (!(food.func_77973_b() instanceof ItemFood)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)food);
        }
        ItemFood foodItem = (ItemFood)food.func_77973_b();
        if (player.func_71024_bL().func_75121_c()) {
            int hunger;
            if (!player.func_184812_l_()) {
                food.func_190920_e(food.func_190916_E() - 1);
            }
            float saturation = foodItem.func_150906_h(food);
            player.func_71024_bL().func_151686_a(new ItemFood(foodItem.func_150905_g(food), saturation += (hunger = 20 - player.func_71024_bL().func_75116_a()) - foodItem.func_150905_g(food) < 0 ? (float)(foodItem.func_150905_g(food) - hunger) : 1.0f, foodItem.func_77845_h()), food);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)food);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)food);
    }

    public static List<ItemStack> format(List<ItemStack> input) {
        HashMap<ItemStackKey, Integer> items = new HashMap<ItemStackKey, Integer>();
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack itemStack : input) {
            ItemStackKey current = new ItemStackKey(itemStack);
            if (items.containsKey(current)) {
                int amount = (Integer)items.get(current);
                items.replace(current, ++amount);
                continue;
            }
            items.put(current, 1);
        }
        for (Map.Entry entry : items.entrySet()) {
            ItemStack stack = ((ItemStackKey)entry.getKey()).getItemStack();
            stack.func_190920_e(((Integer)entry.getValue()).intValue());
            output.add(stack);
        }
        return output;
    }

    public static String format(long value) {
        return new DecimalFormat("###,###.##").format(value);
    }

    public static String format(double value) {
        return new DecimalFormat("###,###.##").format(value);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ModularHUD {
        private byte stringAmount = 0;
        private final List<String> stringList = new ArrayList<String>();
        private static final Minecraft mc = Minecraft.func_71410_x();

        public void newString(String string) {
            this.stringAmount = (byte)(this.stringAmount + 1);
            this.stringList.add(string);
        }

        public void draw() {
            for (int i = 0; i < this.stringAmount; ++i) {
                Pair<Integer, Integer> coords = this.getStringCoord(i);
                ModularHUD.mc.field_71456_v.func_73731_b(ModularHUD.mc.field_71466_p, this.stringList.get(i), ((Integer)coords.getLeft()).intValue(), ((Integer)coords.getRight()).intValue(), 0xFFFFFF);
            }
        }

        @Nonnull
        private Pair<Integer, Integer> getStringCoord(int index) {
            int posY;
            int posX;
            int fontHeight = ModularHUD.mc.field_71466_p.field_78288_b;
            int windowHeight = new ScaledResolution(mc).func_78328_b();
            int windowWidth = new ScaledResolution(mc).func_78326_a();
            int stringWidth = ModularHUD.mc.field_71466_p.func_78256_a(this.stringList.get(index));
            if (ConfigHolder.client.armorHud.hudLocation == 1) {
                posX = 1 + ConfigHolder.client.armorHud.hudOffsetX;
                posY = 1 + ConfigHolder.client.armorHud.hudOffsetY + fontHeight * index;
            } else if (ConfigHolder.client.armorHud.hudLocation == 2) {
                posX = windowWidth - (1 + ConfigHolder.client.armorHud.hudOffsetX) - stringWidth;
                posY = 1 + ConfigHolder.client.armorHud.hudOffsetY + fontHeight * index;
            } else if (ConfigHolder.client.armorHud.hudLocation == 3) {
                posX = 1 + ConfigHolder.client.armorHud.hudOffsetX;
                posY = windowHeight - fontHeight * (this.stringAmount - index) - 1 - ConfigHolder.client.armorHud.hudOffsetY;
            } else if (ConfigHolder.client.armorHud.hudLocation == 4) {
                posX = windowWidth - (1 + ConfigHolder.client.armorHud.hudOffsetX) - stringWidth;
                posY = windowHeight - fontHeight * (this.stringAmount - index) - 1 - ConfigHolder.client.armorHud.hudOffsetY;
            } else {
                throw new IllegalArgumentException("Armor Hud config hudLocation is improperly configured.");
            }
            return Pair.of((Object)posX, (Object)posY);
        }

        public void reset() {
            this.stringAmount = 0;
            this.stringList.clear();
        }
    }
}

