/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import gregtech.api.GTValues;
import gregtech.api.block.VariantActiveBlock;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMaintenanceHatch;
import gregtech.api.capability.IMufflerHatch;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.metatileentity.IVoidable;
import gregtech.api.metatileentity.multiblock.IMaintenance;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MultiblockWithDisplayBase
extends MultiblockControllerBase
implements IMaintenance {
    private boolean voidingItems = false;
    private boolean voidingFluids = false;
    private IVoidable.VoidingMode voidingMode;
    protected final List<ItemStack> recoveryItems = new ArrayList<ItemStack>(){
        {
            this.add(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Ash));
        }
    };
    private int timeActive;
    private static final int minimumMaintenanceTime = 3456000;
    protected byte maintenance_problems = 0;
    private boolean storedTaped = false;
    private final String NBT_VOIDING_MODE = "VoidingMode";
    private final String NBT_VOIDING_ITEMS = "VoidingItems";
    private final String NBT_VOIDING_FLUIDS = "VoidingFluids";
    protected List<BlockPos> variantActiveBlocks;
    protected boolean lastActive;

    public MultiblockWithDisplayBase(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.voidingMode = IVoidable.VoidingMode.VOID_NONE;
    }

    @Override
    public void setMaintenanceFixed(int index) {
        this.maintenance_problems = (byte)(this.maintenance_problems | 1 << index);
    }

    @Override
    public void causeMaintenanceProblems() {
        this.maintenance_problems = (byte)(this.maintenance_problems & ~(1 << (int)(GTValues.RNG.nextFloat() * 5.0f)));
    }

    @Override
    public byte getMaintenanceProblems() {
        return ConfigHolder.machines.enableMaintenance ? (byte)this.maintenance_problems : (byte)63;
    }

    @Override
    public int getNumMaintenanceProblems() {
        return ConfigHolder.machines.enableMaintenance ? 6 - Integer.bitCount(this.maintenance_problems) : 0;
    }

    @Override
    public boolean hasMaintenanceProblems() {
        return ConfigHolder.machines.enableMaintenance && this.maintenance_problems < 63;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return true;
    }

    public boolean hasMufflerMechanics() {
        return false;
    }

    public void calculateMaintenance(int duration) {
        if (!ConfigHolder.machines.enableMaintenance || !this.hasMaintenanceMechanics()) {
            return;
        }
        IMaintenanceHatch maintenanceHatch = this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).get(0);
        if (maintenanceHatch.isFullAuto()) {
            return;
        }
        this.timeActive = (int)((double)this.timeActive + (double)duration * maintenanceHatch.getTimeMultiplier());
        if (3456000 - this.timeActive <= 0 && GTValues.RNG.nextFloat() - 0.75f >= 0.0f) {
            this.causeMaintenanceProblems();
            maintenanceHatch.setTaped(false);
            this.timeActive -= 3456000;
        }
    }

    @Override
    public boolean isStructureObstructed() {
        return this.hasMufflerMechanics() && !this.isMufflerFaceFree();
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        if (this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance) {
            if (this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).isEmpty()) {
                return;
            }
            IMaintenanceHatch maintenanceHatch = this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).get(0);
            if (maintenanceHatch.startWithoutProblems()) {
                this.maintenance_problems = (byte)63;
                this.timeActive = 0;
            }
            this.readMaintenanceData(maintenanceHatch);
            if (this.storedTaped) {
                maintenanceHatch.setTaped(true);
                this.storeTaped(false);
            }
        }
        this.variantActiveBlocks = context.getOrDefault("VABlock", new LinkedList());
        VariantActiveBlock.ACTIVE_BLOCKS.putIfAbsent((Object)this.getWorld().field_73011_w.getDimension(), (Object)new ObjectOpenHashSet());
        this.replaceVariantBlocksActive(false);
    }

    @Override
    public void update() {
        boolean state;
        super.update();
        if (!this.getWorld().field_72995_K && this.lastActive != (state = this.isActive())) {
            this.setLastActive(state);
            this.markDirty();
            this.replaceVariantBlocksActive(this.lastActive);
        }
    }

    public void setLastActive(boolean lastActive) {
        this.lastActive = lastActive;
        this.writeCustomData(100, buf -> buf.writeBoolean(lastActive));
    }

    @Override
    public void storeTaped(boolean isTaped) {
        this.storedTaped = isTaped;
        this.writeCustomData(552, buf -> buf.writeBoolean(isTaped));
    }

    private void readMaintenanceData(IMaintenanceHatch hatch) {
        if (hatch.hasMaintenanceData()) {
            Tuple<Byte, Integer> data = hatch.readMaintenanceData();
            this.maintenance_problems = (Byte)data.func_76341_a();
            this.timeActive = (Integer)data.func_76340_b();
        }
    }

    public void outputRecoveryItems() {
        IMufflerHatch muffler = this.getAbilities(MultiblockAbility.MUFFLER_HATCH).get(0);
        muffler.recoverItemsTable((List<ItemStack>)GTUtility.copyStackList(this.recoveryItems));
    }

    public void outputRecoveryItems(int parallel) {
        IMufflerHatch muffler = this.getAbilities(MultiblockAbility.MUFFLER_HATCH).get(0);
        ArrayList<ItemStack> parallelRecover = new ArrayList<ItemStack>();
        IntStream.range(0, parallel).forEach(value -> parallelRecover.addAll(this.recoveryItems));
        muffler.recoverItemsTable((List<ItemStack>)GTUtility.copyStackList(parallelRecover));
    }

    public boolean isMufflerFaceFree() {
        if (this.hasMufflerMechanics() && this.getAbilities(MultiblockAbility.MUFFLER_HATCH).size() == 0) {
            return false;
        }
        return this.isStructureFormed() && this.hasMufflerMechanics() && this.getAbilities(MultiblockAbility.MUFFLER_HATCH).get(0).isFrontFaceFree();
    }

    @SideOnly(value=Side.CLIENT)
    public void runMufflerEffect(float xPos, float yPos, float zPos, float xSpd, float ySpd, float zSpd) {
        this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)xPos, (double)yPos, (double)zPos, (double)xSpd, (double)ySpd, (double)zSpd, new int[0]);
    }

    protected void setRecoveryItems(ItemStack ... recoveryItems) {
        this.recoveryItems.clear();
        this.recoveryItems.addAll(Arrays.asList(recoveryItems));
    }

    @Override
    public boolean isActive() {
        return this.isStructureFormed();
    }

    @Override
    public void invalidateStructure() {
        if (this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance && !this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).isEmpty()) {
            this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).get(0).storeMaintenanceData(this.maintenance_problems, this.timeActive);
        }
        this.lastActive = false;
        this.replaceVariantBlocksActive(false);
        super.invalidateStructure();
    }

    protected void replaceVariantBlocksActive(boolean isActive) {
        if (this.variantActiveBlocks != null && !this.variantActiveBlocks.isEmpty()) {
            int id = this.getWorld().field_73011_w.getDimension();
            this.writeCustomData(410, buf -> {
                buf.writeInt(id);
                buf.writeBoolean(isActive);
                buf.writeInt(this.variantActiveBlocks.size());
                for (BlockPos blockPos : this.variantActiveBlocks) {
                    if (isActive) {
                        ((ObjectSet)VariantActiveBlock.ACTIVE_BLOCKS.get((Object)id)).add((Object)blockPos);
                    } else {
                        ((ObjectSet)VariantActiveBlock.ACTIVE_BLOCKS.get((Object)id)).remove((Object)blockPos);
                    }
                    buf.func_179255_a(blockPos);
                }
            });
        }
    }

    public TraceabilityPredicate autoAbilities() {
        return this.autoAbilities(true, true);
    }

    public TraceabilityPredicate autoAbilities(boolean checkMaintenance, boolean checkMuffler) {
        TraceabilityPredicate predicate = new TraceabilityPredicate();
        if (checkMaintenance && this.hasMaintenanceMechanics()) {
            predicate = predicate.or(MultiblockWithDisplayBase.abilities(MultiblockAbility.MAINTENANCE_HATCH).setMinGlobalLimited(ConfigHolder.machines.enableMaintenance ? 1 : 0).setMaxGlobalLimited(1));
        }
        if (checkMuffler && this.hasMufflerMechanics()) {
            predicate = predicate.or(MultiblockWithDisplayBase.abilities(MultiblockAbility.MUFFLER_HATCH).setMinGlobalLimited(1).setMaxGlobalLimited(1));
        }
        return predicate;
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        if (!this.isStructureFormed()) {
            TextComponentTranslation tooltip = new TextComponentTranslation("gregtech.multiblock.invalid_structure.tooltip", new Object[0]);
            tooltip.func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            textList.add(new TextComponentTranslation("gregtech.multiblock.invalid_structure", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)tooltip))));
        } else {
            if (this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance) {
                this.addMaintenanceText(textList);
            }
            if (this.hasMufflerMechanics() && !this.isMufflerFaceFree()) {
                textList.add(new TextComponentTranslation("gregtech.multiblock.universal.muffler_obstructed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("gregtech.multiblock.universal.muffler_obstructed.tooltip", new Object[0])))));
            }
        }
    }

    protected void addMaintenanceText(List<ITextComponent> textList) {
        if (!this.hasMaintenanceProblems()) {
            textList.add(new TextComponentTranslation("gregtech.multiblock.universal.no_problems", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        } else {
            ITextComponent hoverEventTranslation = new TextComponentTranslation("gregtech.multiblock.universal.has_problems_header", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            if ((this.maintenance_problems & 1) == 0) {
                hoverEventTranslation.func_150257_a((ITextComponent)new TextComponentTranslation("gregtech.multiblock.universal.problem.wrench", new Object[]{"\n"}));
            }
            if ((this.maintenance_problems >> 1 & 1) == 0) {
                hoverEventTranslation.func_150257_a((ITextComponent)new TextComponentTranslation("gregtech.multiblock.universal.problem.screwdriver", new Object[]{"\n"}));
            }
            if ((this.maintenance_problems >> 2 & 1) == 0) {
                hoverEventTranslation.func_150257_a((ITextComponent)new TextComponentTranslation("gregtech.multiblock.universal.problem.soft_mallet", new Object[]{"\n"}));
            }
            if ((this.maintenance_problems >> 3 & 1) == 0) {
                hoverEventTranslation.func_150257_a((ITextComponent)new TextComponentTranslation("gregtech.multiblock.universal.problem.hard_hammer", new Object[]{"\n"}));
            }
            if ((this.maintenance_problems >> 4 & 1) == 0) {
                hoverEventTranslation.func_150257_a((ITextComponent)new TextComponentTranslation("gregtech.multiblock.universal.problem.wire_cutter", new Object[]{"\n"}));
            }
            if ((this.maintenance_problems >> 5 & 1) == 0) {
                hoverEventTranslation.func_150257_a((ITextComponent)new TextComponentTranslation("gregtech.multiblock.universal.problem.crowbar", new Object[]{"\n"}));
            }
            TextComponentTranslation textTranslation = new TextComponentTranslation("gregtech.multiblock.universal.has_problems", new Object[0]);
            textList.add(textTranslation.func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverEventTranslation))));
        }
    }

    protected void handleDisplayClick(String componentData, Widget.ClickData clickData) {
    }

    protected ModularUI.Builder createUITemplate(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.extendedBuilder();
        builder.image(7, 4, 162, 121, GuiTextures.DISPLAY);
        builder.label(11, 9, this.getMetaFullName(), 0xFFFFFF);
        builder.widget(new AdvancedTextWidget(11, 19, this::addDisplayText, 0xFFFFFF).setMaxWidthLimit(156).setClickHandler(this::handleDisplayClick));
        if (this.shouldShowVoidingModeButton()) {
            builder.widget(new ImageCycleButtonWidget(149, 104, 18, 18, GuiTextures.BUTTON_VOID_MULTIBLOCK, 4, this::getVoidingMode, this::setVoidingMode).setTooltipHoverString(this::getVoidingModeTooltip));
        }
        builder.bindPlayerInventory(entityPlayer.field_71071_by, 134);
        return builder;
    }

    protected boolean shouldShowVoidingModeButton() {
        return true;
    }

    protected int getVoidingMode() {
        return this.voidingMode.ordinal();
    }

    private void setVoidingMode(int mode) {
        this.voidingMode = IVoidable.VoidingMode.VALUES[mode];
        this.voidingFluids = mode >= 2;
        this.voidingItems = mode == 1 || mode == 3;
        for (IFluidTank tank : this.getAbilities(MultiblockAbility.IMPORT_FLUIDS)) {
            this.getNotifiedFluidInputList().add((IFluidHandler)tank);
        }
        this.getNotifiedItemInputList().addAll(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.markDirty();
    }

    private String getVoidingModeTooltip(int mode) {
        return IVoidable.VoidingMode.VALUES[mode].func_176610_l();
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createUITemplate(entityPlayer).build(this.getHolder(), entityPlayer);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("Maintenance", this.maintenance_problems);
        data.func_74768_a("ActiveTimer", this.timeActive);
        data.func_74757_a("VoidingItems", this.voidingItems);
        data.func_74757_a("VoidingFluids", this.voidingFluids);
        data.func_74768_a("VoidingMode", this.voidingMode.ordinal());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.maintenance_problems = data.func_74771_c("Maintenance");
        this.timeActive = data.func_74762_e("ActiveTimer");
        if (data.func_74764_b("VoidingItems")) {
            this.voidingItems = data.func_74767_n("VoidingItems");
        }
        if (data.func_74764_b("VoidingFluids")) {
            this.voidingFluids = data.func_74767_n("VoidingFluids");
        }
        if (data.func_74764_b("VoidingMode")) {
            this.voidingMode = IVoidable.VoidingMode.values()[data.func_74762_e("VoidingMode")];
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte((int)this.maintenance_problems);
        buf.writeInt(this.timeActive);
        buf.writeBoolean(this.voidingFluids);
        buf.writeBoolean(this.voidingItems);
        buf.writeInt(this.voidingMode.ordinal());
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.maintenance_problems = buf.readByte();
        this.timeActive = buf.readInt();
        this.voidingFluids = buf.readBoolean();
        this.voidingItems = buf.readBoolean();
        this.voidingMode = IVoidable.VoidingMode.values()[buf.readInt()];
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 552) {
            this.storedTaped = buf.readBoolean();
        }
        if (dataId == 410) {
            int minZ = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minX = Integer.MAX_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxX = Integer.MIN_VALUE;
            int id = buf.readInt();
            boolean isActive = buf.readBoolean();
            VariantActiveBlock.ACTIVE_BLOCKS.putIfAbsent((Object)this.getWorld().field_73011_w.getDimension(), (Object)new ObjectOpenHashSet());
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                BlockPos blockPos = buf.func_179259_c();
                if (isActive) {
                    ((ObjectSet)VariantActiveBlock.ACTIVE_BLOCKS.get((Object)id)).add((Object)blockPos);
                } else {
                    ((ObjectSet)VariantActiveBlock.ACTIVE_BLOCKS.get((Object)id)).remove((Object)blockPos);
                }
                minX = Math.min(minX, blockPos.func_177958_n());
                minY = Math.min(minY, blockPos.func_177956_o());
                minZ = Math.min(minZ, blockPos.func_177952_p());
                maxX = Math.max(maxX, blockPos.func_177958_n());
                maxY = Math.max(maxY, blockPos.func_177956_o());
                maxZ = Math.max(maxZ, blockPos.func_177952_p());
            }
            if (this.getWorld().field_73011_w.getDimension() == id) {
                this.getWorld().func_175704_b(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
            }
        }
        if (dataId == 100) {
            this.lastActive = buf.readBoolean();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        T capabilityResult = super.getCapability(capability, side);
        if (capabilityResult != null) {
            return capabilityResult;
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_MAINTENANCE && this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance) {
            return (T)GregtechTileCapabilities.CAPABILITY_MAINTENANCE.cast((Object)this);
        }
        return null;
    }

    @Override
    public boolean canVoidRecipeFluidOutputs() {
        return this.voidingFluids;
    }

    @Override
    public boolean canVoidRecipeItemOutputs() {
        return this.voidingItems;
    }
}

