/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.block;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.Cuboid6;
import gregtech.api.GregTechAPI;
import gregtech.api.block.BuiltInRenderBlock;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import gregtech.api.cover.IFacadeCover;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.pipenet.IBlockAppearance;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.block.ItemBlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.FrameItemBlock;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.integration.ctm.IFacadeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockPipe<PipeType extends Enum<PipeType>, NodeDataType, WorldPipeNetType extends WorldPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends BuiltInRenderBlock
implements ITileEntityProvider,
IFacadeWrapper,
IBlockAppearance {
    protected final ThreadLocal<IPipeTile<PipeType, NodeDataType>> tileEntities = new ThreadLocal();

    public BlockPipe() {
        super(Material.field_151573_f);
        this.func_149663_c("pipe");
        this.func_149647_a(GregTechAPI.TAB_GREGTECH);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(3.0f);
        this.func_149713_g(0);
        this.func_149649_H();
    }

    public static Cuboid6 getSideBox(EnumFacing side, float thickness) {
        Cuboid6 cuboid;
        float min = (1.0f - thickness) / 2.0f;
        float max = min + thickness;
        float faceMin = 0.0f;
        float faceMax = 1.0f;
        if (side == null) {
            return new Cuboid6((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
        }
        switch (side) {
            case WEST: {
                cuboid = new Cuboid6((double)faceMin, (double)min, (double)min, (double)min, (double)max, (double)max);
                break;
            }
            case EAST: {
                cuboid = new Cuboid6((double)max, (double)min, (double)min, (double)faceMax, (double)max, (double)max);
                break;
            }
            case NORTH: {
                cuboid = new Cuboid6((double)min, (double)min, (double)faceMin, (double)max, (double)max, (double)min);
                break;
            }
            case SOUTH: {
                cuboid = new Cuboid6((double)min, (double)min, (double)max, (double)max, (double)max, (double)faceMax);
                break;
            }
            case UP: {
                cuboid = new Cuboid6((double)min, (double)max, (double)min, (double)max, (double)faceMax, (double)max);
                break;
            }
            case DOWN: {
                cuboid = new Cuboid6((double)min, (double)faceMin, (double)min, (double)max, (double)min, (double)max);
                break;
            }
            default: {
                cuboid = new Cuboid6((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
            }
        }
        return cuboid;
    }

    public static Cuboid6 getCoverSideBox(EnumFacing side, float thickness) {
        Cuboid6 cuboid = BlockPipe.getSideBox(side, thickness);
        if (side != null) {
            cuboid.setSide(side, side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 0.001 : 0.999);
        }
        return cuboid;
    }

    public abstract Class<PipeType> getPipeTypeClass();

    public abstract WorldPipeNetType getWorldPipeNet(World var1);

    public abstract TileEntityPipeBase<PipeType, NodeDataType> createNewTileEntity(boolean var1);

    public abstract NodeDataType createProperties(IPipeTile<PipeType, NodeDataType> var1);

    public abstract NodeDataType createItemProperties(ItemStack var1);

    public abstract ItemStack getDropItem(IPipeTile<PipeType, NodeDataType> var1);

    protected abstract NodeDataType getFallbackType();

    public abstract PipeType getItemPipeType(ItemStack var1);

    public abstract void setTileEntityData(TileEntityPipeBase<PipeType, NodeDataType> var1, ItemStack var2);

    public abstract void func_149666_a(@Nonnull CreativeTabs var1, @Nonnull NonNullList<ItemStack> var2);

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null) {
            pipeTile.getCoverableImplementation().dropAllCovers();
            this.tileEntities.set(pipeTile);
        }
        super.func_180663_b(worldIn, pos, state);
        ((WorldPipeNet)((Object)this.getWorldPipeNet(worldIn))).removeNode(pos);
    }

    public void func_176213_c(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, 1);
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null) {
            int activeConnections = pipeTile.getConnections();
            boolean isActiveNode = activeConnections != 0;
            ((WorldPipeNet)((Object)this.getWorldPipeNet(worldIn))).addNode(pos, this.createProperties(pipeTile), 0, activeConnections, isActiveNode);
            this.onActiveModeChange(worldIn, pos, isActiveNode, true);
        }
    }

    public void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null) {
            this.setTileEntityData((TileEntityPipeBase)pipeTile, stack);
            if (placer instanceof EntityPlayer) {
                ItemStack offhand = placer.func_184592_cb();
                for (int i = 0; i < EnumDyeColor.values().length; ++i) {
                    if (!offhand.func_77969_a(MetaItems.SPRAY_CAN_DYES[i].getStackForm())) continue;
                    MetaItems.SPRAY_CAN_DYES[i].getBehaviours().get(0).onItemUse((EntityPlayer)placer, worldIn, pos, EnumHand.OFF_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                    break;
                }
            }
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        IPipeTile<PipeType, NodeDataType> pipeTile;
        if (worldIn.field_72995_K) {
            return;
        }
        if (!ConfigHolder.machines.gt6StylePipesCables && (pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos)) != null) {
            boolean canConnect;
            EnumFacing facing = null;
            for (EnumFacing facing1 : EnumFacing.values()) {
                if (!GTUtility.arePosEqual(fromPos, pos.func_177972_a(facing1))) continue;
                facing = facing1;
                break;
            }
            if (facing == null) {
                return;
            }
            boolean open = pipeTile.isConnected(facing);
            boolean bl = canConnect = pipeTile.getCoverableImplementation().getCoverAtSide(facing) != null || this.canConnect(pipeTile, facing);
            if (!open && canConnect && state.func_177230_c() != blockIn) {
                pipeTile.setConnection(facing, true, false);
            }
            if (open && !canConnect) {
                pipeTile.setConnection(facing, false, false);
            }
            this.updateActiveNodeStatus(worldIn, pos, pipeTile);
            pipeTile.getCoverableImplementation().updateInputRedstoneSignals();
        }
    }

    public void observedNeighborChange(@Nonnull IBlockState observerState, @Nonnull World world, @Nonnull BlockPos observerPos, @Nonnull Block changedBlock, @Nonnull BlockPos changedBlockPos) {
        Object net = ((WorldPipeNet)((Object)this.getWorldPipeNet(world))).getNetFromPos(observerPos);
        if (net != null) {
            ((PipeNet)net).onNeighbourUpdate(changedBlockPos);
        }
    }

    public boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity(world, pos);
        return pipeTile != null && pipeTile.getCoverableImplementation().canConnectRedstone(side);
    }

    public boolean shouldCheckWeakPower(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return false;
    }

    public int func_180656_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity(blockAccess, pos);
        return pipeTile == null ? 0 : pipeTile.getCoverableImplementation().getOutputRedstoneSignal(side.func_176734_d());
    }

    public void updateActiveNodeStatus(World worldIn, BlockPos pos, IPipeTile<PipeType, NodeDataType> pipeTile) {
        int activeConnections;
        boolean isActiveNodeNow;
        boolean modeChanged;
        Object pipeNet = ((WorldPipeNet)((Object)this.getWorldPipeNet(worldIn))).getNetFromPos(pos);
        if (pipeNet != null && pipeTile != null && (modeChanged = ((PipeNet)pipeNet).markNodeAsActive(pos, isActiveNodeNow = (activeConnections = pipeTile.getConnections()) != 0))) {
            this.onActiveModeChange(worldIn, pos, isActiveNodeNow, false);
        }
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return this.createNewTileEntity(false);
    }

    protected void onActiveModeChange(World world, BlockPos pos, boolean isActiveNow, boolean isInitialChange) {
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)world, pos);
        if (pipeTile == null) {
            return ItemStack.field_190927_a;
        }
        if (target instanceof CuboidRayTraceResult) {
            CuboidRayTraceResult result = (CuboidRayTraceResult)target;
            if (result.cuboid6.data instanceof ICoverable.CoverSideData) {
                EnumFacing coverSide = ((ICoverable.CoverSideData)result.cuboid6.data).side;
                CoverBehavior coverBehavior = pipeTile.getCoverableImplementation().getCoverAtSide(coverSide);
                return coverBehavior == null ? ItemStack.field_190927_a : coverBehavior.getPickItem();
            }
        }
        return this.getDropItem(pipeTile);
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)RayTracer.retraceBlock((World)worldIn, (EntityPlayer)playerIn, (BlockPos)pos);
        if (rayTraceResult == null || pipeTile == null) {
            return false;
        }
        return this.onPipeActivated(worldIn, state, pos, playerIn, hand, facing, rayTraceResult, pipeTile);
    }

    public boolean onPipeActivated(World world, IBlockState state, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, EnumFacing side, CuboidRayTraceResult hit, IPipeTile<PipeType, NodeDataType> pipeTile) {
        CoverBehavior coverBehavior;
        EnumFacing coverSide;
        IBlockState blockStateAtSide;
        ItemStack itemStack = entityPlayer.func_184586_b(hand);
        if (pipeTile.getFrameMaterial() == null && pipeTile instanceof TileEntityPipeBase && itemStack.func_77973_b() instanceof FrameItemBlock && ((IPipeType)pipeTile.getPipeType()).getThickness() < 1.0f) {
            BlockFrame frameBlock = (BlockFrame)((FrameItemBlock)itemStack.func_77973_b()).func_179223_d();
            gregtech.api.unification.material.Material material = frameBlock.getGtMaterial(itemStack.func_77960_j());
            ((TileEntityPipeBase)pipeTile).setFrameMaterial(material);
            SoundType type = frameBlock.getSoundType(itemStack);
            world.func_184133_a(entityPlayer, pos, type.func_185841_e(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            return true;
        }
        if (itemStack.func_77973_b() instanceof ItemBlockPipe && (blockStateAtSide = world.func_180495_p(pos.func_177972_a(side))).func_177230_c() instanceof BlockFrame) {
            ItemBlockPipe itemBlockPipe = (ItemBlockPipe)itemStack.func_77973_b();
            if (itemBlockPipe.blockPipe.getItemPipeType(itemStack) == this.getItemPipeType(itemStack)) {
                BlockFrame frameBlock = (BlockFrame)blockStateAtSide.func_177230_c();
                boolean wasPlaced = frameBlock.replaceWithFramedPipe(world, pos.func_177972_a(side), blockStateAtSide, entityPlayer, itemStack, side);
                if (wasPlaced) {
                    pipeTile.setConnection(side, true, false);
                }
                return wasPlaced;
            }
        }
        if ((coverSide = ICoverable.traceCoverSide((RayTraceResult)hit)) == null) {
            return this.activateFrame(world, state, pos, entityPlayer, hand, hit, pipeTile);
        }
        if (!(hit.cuboid6.data instanceof ICoverable.CoverSideData)) {
            switch (this.onPipeToolUsed(world, pos, itemStack, coverSide, pipeTile, entityPlayer)) {
                case SUCCESS: {
                    return true;
                }
                case FAIL: {
                    return false;
                }
            }
        }
        if ((coverBehavior = pipeTile.getCoverableImplementation().getCoverAtSide(coverSide)) == null) {
            return this.activateFrame(world, state, pos, entityPlayer, hand, hit, pipeTile);
        }
        if (itemStack.func_77973_b().getToolClasses(itemStack).contains("screwdriver") && coverBehavior.onScrewdriverClick(entityPlayer, hand, hit) == EnumActionResult.SUCCESS) {
            ToolHelper.damageItem(itemStack, (EntityLivingBase)entityPlayer);
            if (itemStack.func_77973_b() instanceof IGTTool) {
                ((IGTTool)itemStack.func_77973_b()).playSound(entityPlayer);
            }
            return true;
        }
        EnumActionResult result = coverBehavior.onRightClick(entityPlayer, hand, hit);
        if (result == EnumActionResult.PASS) {
            if (this.activateFrame(world, state, pos, entityPlayer, hand, hit, pipeTile)) {
                return true;
            }
            return entityPlayer.func_70093_af() && entityPlayer.func_184614_ca().func_190926_b() && coverBehavior.onScrewdriverClick(entityPlayer, hand, hit) != EnumActionResult.PASS;
        }
        return true;
    }

    private boolean activateFrame(World world, IBlockState state, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, CuboidRayTraceResult hit, IPipeTile<PipeType, NodeDataType> pipeTile) {
        if (pipeTile.getFrameMaterial() != null && !(entityPlayer.func_184586_b(hand).func_77973_b() instanceof ItemBlockPipe)) {
            BlockFrame blockFrame = MetaBlocks.FRAMES.get(pipeTile.getFrameMaterial());
            return blockFrame.func_180639_a(world, pos, state, entityPlayer, hand, hit.field_178784_b, (float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c);
        }
        return false;
    }

    public EnumActionResult onPipeToolUsed(World world, BlockPos pos, ItemStack stack, EnumFacing coverSide, IPipeTile<PipeType, NodeDataType> pipeTile, EntityPlayer entityPlayer) {
        if (this.isPipeTool(stack) && !entityPlayer.field_70170_p.field_72995_K) {
            if (entityPlayer.func_70093_af() && pipeTile.canHaveBlockedFaces()) {
                boolean isBlocked = pipeTile.isFaceBlocked(coverSide);
                pipeTile.setFaceBlocked(coverSide, !isBlocked);
                if (stack.func_77973_b() instanceof IGTTool) {
                    ((IGTTool)stack.func_77973_b()).playSound(entityPlayer);
                }
            } else {
                boolean isOpen = pipeTile.isConnected(coverSide);
                pipeTile.setConnection(coverSide, !isOpen, false);
                if (stack.func_77973_b() instanceof IGTTool && isOpen != pipeTile.isConnected(coverSide)) {
                    ((IGTTool)stack.func_77973_b()).playSound(entityPlayer);
                }
            }
            ToolHelper.damageItem(stack, (EntityLivingBase)entityPlayer);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    protected boolean isPipeTool(@Nonnull ItemStack stack) {
        return ToolHelper.isTool(stack, "wrench");
    }

    public void func_180649_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EntityPlayer playerIn) {
        CoverBehavior coverBehavior;
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)RayTracer.retraceBlock((World)worldIn, (EntityPlayer)playerIn, (BlockPos)pos);
        if (pipeTile == null || rayTraceResult == null) {
            return;
        }
        EnumFacing coverSide = ICoverable.traceCoverSide((RayTraceResult)rayTraceResult);
        CoverBehavior coverBehavior2 = coverBehavior = coverSide == null ? null : pipeTile.getCoverableImplementation().getCoverAtSide(coverSide);
        if (coverBehavior != null) {
            coverBehavior.onLeftClick(playerIn, rayTraceResult);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null && pipeTile.getFrameMaterial() != null) {
            BlockFrame blockFrame = MetaBlocks.FRAMES.get(pipeTile.getFrameMaterial());
            blockFrame.func_180634_a(worldIn, pos, state, entityIn);
        }
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        this.tileEntities.set(te == null ? this.tileEntities.get() : (IPipeTile<PipeType, NodeDataType>)te);
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.tileEntities.set(null);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        IPipeTile<PipeType, NodeDataType> pipeTile;
        IPipeTile<PipeType, NodeDataType> iPipeTile = pipeTile = this.tileEntities.get() == null ? this.getPipeTileEntity(world, pos) : this.tileEntities.get();
        if (pipeTile == null) {
            return;
        }
        if (pipeTile.getFrameMaterial() != null) {
            BlockFrame blockFrame = MetaBlocks.FRAMES.get(pipeTile.getFrameMaterial());
            drops.add((Object)blockFrame.getItem(pipeTile.getFrameMaterial()));
        }
        drops.add((Object)this.getDropItem(pipeTile));
    }

    public void func_185477_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null && pipeTile.getFrameMaterial() != null) {
            AxisAlignedBB box = BlockFrame.COLLISION_BOX.func_186670_a(pos);
            if (box.func_72326_a(entityBox)) {
                collidingBoxes.add(box);
            }
            return;
        }
        for (Cuboid6 cuboid6 : this.getCollisionBox((IBlockAccess)worldIn, pos, entityIn)) {
            AxisAlignedBB offsetBox = cuboid6.aabb().func_186670_a(pos);
            if (!offsetBox.func_72326_a(entityBox)) continue;
            collidingBoxes.add(offsetBox);
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(@Nonnull IBlockState blockState, World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        if (worldIn.field_72995_K) {
            return this.getClientCollisionRayTrace(worldIn, pos, start, end);
        }
        return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, (IndexedCuboid6[])new IndexedCuboid6[]{MetaTileEntity.FULL_CUBE_COLLISION});
    }

    @SideOnly(value=Side.CLIENT)
    public RayTraceResult getClientCollisionRayTrace(World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, this.getCollisionBox((IBlockAccess)worldIn, pos, (Entity)Minecraft.func_71410_x().field_71439_g));
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean recolorBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull EnumDyeColor color) {
        IPipeTile tileEntityPipe = (IPipeTile)world.func_175625_s(pos);
        if (tileEntityPipe != null && tileEntityPipe.getPipeType() != null && ((IPipeType)tileEntityPipe.getPipeType()).isPaintable() && tileEntityPipe.getPaintingColor() != color.field_193351_w) {
            tileEntityPipe.setPaintingColor(color.field_193351_w);
            return true;
        }
        return false;
    }

    protected boolean isThisPipeBlock(Block block) {
        return block != null && block.getClass().isAssignableFrom(this.getClass());
    }

    public IPipeTile<PipeType, NodeDataType> getPipeTileEntity(IBlockAccess world, BlockPos selfPos) {
        TileEntity tileEntityAtPos = world.func_175625_s(selfPos);
        return this.getPipeTileEntity(tileEntityAtPos);
    }

    public IPipeTile<PipeType, NodeDataType> getPipeTileEntity(TileEntity tileEntityAtPos) {
        if (tileEntityAtPos instanceof IPipeTile && this.isThisPipeBlock(((IPipeTile)tileEntityAtPos).getPipeBlock())) {
            return (IPipeTile)tileEntityAtPos;
        }
        return null;
    }

    public boolean canConnect(IPipeTile<PipeType, NodeDataType> selfTile, EnumFacing facing) {
        if (selfTile.getPipeWorld().func_180495_p(selfTile.getPipePos().func_177972_a(facing)).func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        CoverBehavior cover = selfTile.getCoverableImplementation().getCoverAtSide(facing);
        if (cover != null && !cover.canPipePassThrough()) {
            return false;
        }
        TileEntity other = selfTile.getPipeWorld().func_175625_s(selfTile.getPipePos().func_177972_a(facing));
        if (other instanceof IPipeTile) {
            cover = ((IPipeTile)other).getCoverableImplementation().getCoverAtSide(facing.func_176734_d());
            if (cover != null && !cover.canPipePassThrough()) {
                return false;
            }
            return this.canPipesConnect(selfTile, facing, (IPipeTile)other);
        }
        return this.canPipeConnectToBlock(selfTile, facing, other);
    }

    public abstract boolean canPipesConnect(IPipeTile<PipeType, NodeDataType> var1, EnumFacing var2, IPipeTile<PipeType, NodeDataType> var3);

    public abstract boolean canPipeConnectToBlock(IPipeTile<PipeType, NodeDataType> var1, EnumFacing var2, @Nullable TileEntity var3);

    private List<IndexedCuboid6> getCollisionBox(IBlockAccess world, BlockPos pos, @Nullable Entity entityIn) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity(world, pos);
        if (pipeTile == null) {
            return Collections.emptyList();
        }
        if (pipeTile.getFrameMaterial() != null) {
            return Collections.singletonList(MetaTileEntity.FULL_CUBE_COLLISION);
        }
        PipeType pipeType = pipeTile.getPipeType();
        if (pipeType == null) {
            return Collections.emptyList();
        }
        int actualConnections = this.getPipeTileEntity(world, pos).getVisualConnections();
        float thickness = ((IPipeType)pipeType).getThickness();
        ArrayList<IndexedCuboid6> result = new ArrayList<IndexedCuboid6>();
        PipeCoverableImplementation coverable = pipeTile.getCoverableImplementation();
        if (this.hasPipeCollisionChangingItem(world, pos, entityIn)) {
            result.add(MetaTileEntity.FULL_CUBE_COLLISION);
        }
        result.add(new IndexedCuboid6((Object)new ICoverable.PrimaryBoxData(true), BlockPipe.getSideBox(null, thickness)));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if ((actualConnections & 1 << side.func_176745_a()) <= 0) continue;
            result.add(new IndexedCuboid6((Object)new PipeConnectionData(side), BlockPipe.getSideBox(side, thickness)));
        }
        coverable.addCoverCollisionBoundingBox(result);
        return result;
    }

    public boolean hasPipeCollisionChangingItem(IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityPlayer) {
            return this.hasPipeCollisionChangingItem(world, pos, ((EntityPlayer)entity).func_184586_b(EnumHand.MAIN_HAND)) || this.hasPipeCollisionChangingItem(world, pos, ((EntityPlayer)entity).func_184586_b(EnumHand.OFF_HAND)) || entity.func_70093_af() && this.isHoldingPipe((EntityPlayer)entity);
        }
        return false;
    }

    public abstract boolean isHoldingPipe(EntityPlayer var1);

    public boolean hasPipeCollisionChangingItem(IBlockAccess world, BlockPos pos, ItemStack stack) {
        return this.isPipeTool(stack) || ToolHelper.isTool(stack, "screwdriver") || GTUtility.isCoverBehaviorItem(stack, () -> this.hasCover(this.getPipeTileEntity(world, pos)), coverDef -> ICoverable.canPlaceCover(coverDef, this.getPipeTileEntity(world, pos).getCoverableImplementation()));
    }

    protected boolean hasCover(IPipeTile<PipeType, NodeDataType> pipeTile) {
        if (pipeTile == null) {
            return false;
        }
        return pipeTile.getCoverableImplementation().hasAnyCover();
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    @Override
    @Nonnull
    public IBlockState getFacade(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side, @Nonnull BlockPos otherPos) {
        return this.getFacade(world, pos, side);
    }

    @Override
    @Nonnull
    public IBlockState getFacade(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        CoverBehavior coverBehavior;
        IPipeTile<PipeType, NodeDataType> pipeTileEntity = this.getPipeTileEntity(world, pos);
        if (pipeTileEntity != null && side != null && (coverBehavior = pipeTileEntity.getCoverableImplementation().getCoverAtSide(side)) instanceof IFacadeCover) {
            return ((IFacadeCover)((Object)coverBehavior)).getVisualState();
        }
        return world.func_180495_p(pos);
    }

    @Override
    @Nonnull
    public IBlockState getVisualState(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return this.getFacade(world, pos, side);
    }

    @Override
    public boolean supportsVisualConnections() {
        return true;
    }

    public static class PipeConnectionData {
        public final EnumFacing side;

        public PipeConnectionData(EnumFacing side) {
            this.side = side;
        }
    }
}

