/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.tickable;

import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TickableWorldPipeNet<NodeDataType, T extends PipeNet<NodeDataType>>
extends WorldPipeNet<NodeDataType, T> {
    private final Map<T, List<ChunkPos>> loadedChunksByPipeNet = new HashMap<T, List<ChunkPos>>();
    private final Set<T> tickingPipeNets = new HashSet<T>();
    private final Set<T> removeLater = new HashSet<T>();

    public TickableWorldPipeNet(String name) {
        super(name);
    }

    private boolean isChunkLoaded(ChunkPos chunkPos) {
        WorldServer worldServer = (WorldServer)this.getWorld();
        if (worldServer == null) {
            return false;
        }
        return worldServer.func_72863_F().func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b);
    }

    protected abstract int getUpdateRate();

    public void update() {
        if (this.getWorld().func_82737_E() % (long)this.getUpdateRate() == 0L) {
            this.tickingPipeNets.forEach(net -> ((ITickable)net).func_73660_a());
        }
        if (this.removeLater.size() > 0) {
            this.removeLater.forEach(x$0 -> this.tickingPipeNets.remove(x$0));
            this.removeLater.clear();
        }
    }

    public void onChunkLoaded(Chunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        List pipeNetsInThisChunk = (List)this.pipeNetsByChunk.get(chunkPos);
        if (pipeNetsInThisChunk == null) {
            return;
        }
        for (PipeNet pipeNet : pipeNetsInThisChunk) {
            List<ChunkPos> loadedChunks = this.getOrCreateChunkListForPipeNet(pipeNet);
            if (loadedChunks.isEmpty()) {
                this.tickingPipeNets.add(pipeNet);
            }
            loadedChunks.add(chunkPos);
        }
    }

    public void onChunkUnloaded(Chunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        List pipeNetsInThisChunk = (List)this.pipeNetsByChunk.get(chunkPos);
        if (pipeNetsInThisChunk == null) {
            return;
        }
        for (PipeNet pipeNet : pipeNetsInThisChunk) {
            List<ChunkPos> loadedChunks = this.loadedChunksByPipeNet.get(pipeNet);
            if (loadedChunks == null || !loadedChunks.contains(chunkPos)) continue;
            loadedChunks.remove(chunkPos);
            if (!loadedChunks.isEmpty()) continue;
            this.removeFromTicking(pipeNet);
        }
    }

    @Override
    protected void onWorldSet() {
        super.onWorldSet();
        Map<PipeNet, List> pipeNetByLoadedChunks = this.pipeNets.stream().map(pipeNet -> Pair.of((Object)pipeNet, this.getPipeNetLoadedChunks(pipeNet))).filter(pair -> !((List)pair.getRight()).isEmpty()).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        if (!pipeNetByLoadedChunks.isEmpty()) {
            this.tickingPipeNets.addAll(pipeNetByLoadedChunks.keySet());
            this.loadedChunksByPipeNet.putAll(pipeNetByLoadedChunks);
        }
    }

    @Override
    protected void addPipeNet(T pipeNet) {
        super.addPipeNet(pipeNet);
        List<ChunkPos> loadedChunks = this.getPipeNetLoadedChunks(pipeNet);
        if (!loadedChunks.isEmpty()) {
            this.loadedChunksByPipeNet.put(pipeNet, loadedChunks);
            this.tickingPipeNets.add(pipeNet);
        }
    }

    private List<ChunkPos> getPipeNetLoadedChunks(T pipeNet) {
        return ((PipeNet)pipeNet).getContainedChunks().stream().filter(this::isChunkLoaded).collect(Collectors.toList());
    }

    @Override
    protected void removePipeNet(T pipeNet) {
        super.removePipeNet(pipeNet);
        if (this.loadedChunksByPipeNet.containsKey(pipeNet)) {
            this.removeFromTicking(pipeNet);
        }
    }

    private void removeFromTicking(T pipeNet) {
        this.loadedChunksByPipeNet.remove(pipeNet);
        this.removeLater.add(pipeNet);
    }

    private List<ChunkPos> getOrCreateChunkListForPipeNet(T pipeNet) {
        return this.loadedChunksByPipeNet.computeIfAbsent(pipeNet, k -> new ArrayList());
    }

    @Override
    protected void addPipeNetToChunk(ChunkPos chunkPos, T pipeNet) {
        super.addPipeNetToChunk(chunkPos, pipeNet);
        if (this.isChunkLoaded(chunkPos)) {
            List<ChunkPos> loadedChunks = this.getOrCreateChunkListForPipeNet(pipeNet);
            if (loadedChunks.isEmpty()) {
                this.tickingPipeNets.add(pipeNet);
            }
            loadedChunks.add(chunkPos);
        }
    }

    @Override
    protected void removePipeNetFromChunk(ChunkPos chunkPos, T pipeNet) {
        super.removePipeNetFromChunk(chunkPos, pipeNet);
        List<ChunkPos> loadedChunks = this.loadedChunksByPipeNet.get(pipeNet);
        if (loadedChunks != null && loadedChunks.contains(chunkPos)) {
            loadedChunks.remove(chunkPos);
            if (loadedChunks.isEmpty()) {
                this.removeFromTicking(pipeNet);
            }
        }
    }
}

