/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class CraftTweakerItemInputWrapper
extends GTRecipeInput {
    private final IIngredient ingredient;

    public CraftTweakerItemInputWrapper(IIngredient ingredient) {
        this.ingredient = ingredient;
        this.amount = ingredient.getAmount();
    }

    public static CraftTweakerItemInputWrapper getOrCreate(IIngredient ingredient, int i) {
        return (CraftTweakerItemInputWrapper)CraftTweakerItemInputWrapper.getFromCache(new CraftTweakerItemInputWrapper(ingredient));
    }

    @Override
    protected CraftTweakerItemInputWrapper copy() {
        CraftTweakerItemInputWrapper copy = new CraftTweakerItemInputWrapper(this.ingredient.amount(this.amount));
        copy.isConsumable = this.isConsumable;
        copy.nbtMatcher = this.nbtMatcher;
        copy.nbtCondition = this.nbtCondition;
        return copy;
    }

    @Override
    public CraftTweakerItemInputWrapper copyWithAmount(int amount) {
        CraftTweakerItemInputWrapper copy = new CraftTweakerItemInputWrapper(this.ingredient.amount(amount));
        copy.isConsumable = this.isConsumable;
        copy.nbtMatcher = this.nbtMatcher;
        copy.nbtCondition = this.nbtCondition;
        return copy;
    }

    @Override
    public ItemStack[] getInputStacks() {
        ItemStack[] stacks = new ItemStack[this.ingredient.getItems().size()];
        List items = this.ingredient.getItems();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack;
            IItemStack iitem = (IItemStack)items.get(i);
            stacks[i] = stack = CraftTweakerMC.getItemStack((IItemStack)iitem);
        }
        return stacks;
    }

    @Override
    public boolean acceptsStack(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        for (IItemStack iiStack : this.ingredient.getItems()) {
            if (iiStack.getAmount() > itemStack.func_190916_E()) {
                int oldCount = itemStack.func_190916_E();
                itemStack.func_190920_e(iiStack.getAmount());
                if (iiStack.matches(CraftTweakerMC.getIItemStackForMatching((ItemStack)itemStack, (iiStack.getMetadata() == Short.MAX_VALUE ? 1 : 0) != 0))) {
                    itemStack.func_190920_e(oldCount);
                    return true;
                }
                itemStack.func_190920_e(oldCount);
                return false;
            }
            if (!iiStack.matches(CraftTweakerMC.getIItemStackForMatching((ItemStack)itemStack, (iiStack.getMetadata() == Short.MAX_VALUE ? 1 : 0) != 0))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equalIgnoreAmount(GTRecipeInput input) {
        if (this == input) {
            return true;
        }
        if (!(input instanceof CraftTweakerItemInputWrapper)) {
            return false;
        }
        CraftTweakerItemInputWrapper other = (CraftTweakerItemInputWrapper)input;
        if (this.isConsumable != other.isConsumable) {
            return false;
        }
        if (this.ingredient.getItems().size() != other.ingredient.getItems().size()) {
            return false;
        }
        for (int i = 0; i < this.ingredient.getItems().size(); ++i) {
            if (((IItemStack)this.ingredient.getItems().get(i)).matches((IItemStack)other.ingredient.getItems().get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        for (ItemStack stack : this.getInputStacks()) {
            hash = 31 * hash + stack.func_77973_b().hashCode();
            hash = 31 * hash + stack.func_77960_j();
            if (!stack.func_77942_o() || this.nbtMatcher != null) continue;
            hash = 31 * hash + stack.func_77978_p().hashCode();
        }
        hash = 31 * hash + this.amount;
        hash = 31 * hash + (this.isConsumable ? 1 : 0);
        hash = 31 * hash + (this.nbtMatcher != null ? this.nbtMatcher.hashCode() : 0);
        hash = 31 * hash + (this.nbtCondition != null ? this.nbtCondition.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CraftTweakerItemInputWrapper)) {
            return false;
        }
        CraftTweakerItemInputWrapper other = (CraftTweakerItemInputWrapper)obj;
        if (this.amount != other.amount) {
            return false;
        }
        if (this.isConsumable != other.isConsumable) {
            return false;
        }
        if (this.ingredient.getItems().size() != other.ingredient.getItems().size()) {
            return false;
        }
        for (int i = 0; i < this.ingredient.getItems().size(); ++i) {
            if (((IItemStack)this.ingredient.getItems().get(i)).matches((IItemStack)other.ingredient.getItems().get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNBTMatchingCondition() {
        return true;
    }
}

