/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import crafttweaker.CraftTweakerAPI;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;

public class BlastProperty
implements IMaterialProperty<BlastProperty> {
    private int blastTemperature;
    private GasTier gasTier = null;
    private int durationOverride = -1;
    private int eutOverride = -1;

    public BlastProperty(int blastTemperature) {
        this.blastTemperature = blastTemperature;
    }

    public BlastProperty(int blastTemperature, GasTier gasTier, int eutOverride, int durationOverride) {
        this.blastTemperature = blastTemperature;
        this.gasTier = gasTier;
        this.eutOverride = eutOverride;
        this.durationOverride = durationOverride;
    }

    public BlastProperty() {
        this(0);
    }

    public int getBlastTemperature() {
        return this.blastTemperature;
    }

    public void setBlastTemperature(int blastTemp) {
        if (blastTemp <= 0) {
            throw new IllegalArgumentException("Blast Temperature must be greater than zero!");
        }
        this.blastTemperature = blastTemp;
    }

    public GasTier getGasTier() {
        return this.gasTier;
    }

    public int getDurationOverride() {
        return this.durationOverride;
    }

    public int getEUtOverride() {
        return this.eutOverride;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.INGOT, true);
        FluidProperty fluidProperty = properties.getProperty(PropertyKey.FLUID);
        if (fluidProperty != null && fluidProperty.getFluidTemperature() == 293) {
            fluidProperty.setFluidTemperature(this.blastTemperature);
        }
    }

    public static GasTier validateGasTier(String gasTierName) {
        if (gasTierName == null) {
            return null;
        }
        if (gasTierName.equalsIgnoreCase("LOW")) {
            return GasTier.LOW;
        }
        if (gasTierName.equalsIgnoreCase("MID")) {
            return GasTier.MID;
        }
        if (gasTierName.equalsIgnoreCase("HIGH")) {
            return GasTier.HIGH;
        }
        if (gasTierName.equalsIgnoreCase("HIGHER")) {
            return GasTier.HIGHER;
        }
        if (gasTierName.equalsIgnoreCase("HIGHEST")) {
            return GasTier.HIGHEST;
        }
        CraftTweakerAPI.logError((String)"Gas Tier must be either \"LOW\", \"MID\", \"HIGH\", \"HIGHER\", or \"HIGHEST\"");
        throw new IllegalArgumentException();
    }

    public static enum GasTier {
        LOW,
        MID,
        HIGH,
        HIGHER,
        HIGHEST;

        public static final GasTier[] VALUES;

        static {
            VALUES = GasTier.values();
        }
    }
}

