/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import java.util.Objects;

public class FluidPipeProperties
implements IMaterialProperty<FluidPipeProperties> {
    private int throughput;
    private final int tanks;
    private int maxFluidTemperature;
    private boolean gasProof;
    private boolean acidProof;
    private boolean cryoProof;
    private boolean plasmaProof;

    public FluidPipeProperties(int maxFluidTemperature, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
        this(maxFluidTemperature, throughput, gasProof, acidProof, cryoProof, plasmaProof, 1);
    }

    public FluidPipeProperties(int maxFluidTemperature, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof, int tanks) {
        this.maxFluidTemperature = maxFluidTemperature;
        this.throughput = throughput;
        this.gasProof = gasProof;
        this.acidProof = acidProof;
        this.cryoProof = cryoProof;
        this.plasmaProof = plasmaProof;
        this.tanks = tanks;
    }

    public FluidPipeProperties() {
        this(300, 1, false, false, false, false);
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.INGOT, true);
        if (properties.hasProperty(PropertyKey.ITEM_PIPE)) {
            throw new IllegalStateException("Material " + properties.getMaterial() + " has both Fluid and Item Pipe Property, which is not allowed!");
        }
    }

    public int getTanks() {
        return this.tanks;
    }

    public int getThroughput() {
        return this.throughput;
    }

    public void setThroughput(int throughput) {
        this.throughput = throughput;
    }

    public int getMaxFluidTemperature() {
        return this.maxFluidTemperature;
    }

    public void setMaxFluidTemperature(int maxFluidTemperature) {
        this.maxFluidTemperature = maxFluidTemperature;
    }

    public boolean isGasProof() {
        return this.gasProof;
    }

    public void setGasProof(boolean gasProof) {
        this.gasProof = gasProof;
    }

    public boolean isAcidProof() {
        return this.acidProof;
    }

    public void setAcidProof(boolean acidProof) {
        this.acidProof = acidProof;
    }

    public boolean isCryoProof() {
        return this.cryoProof;
    }

    public void setCryoProof(boolean cryoProof) {
        this.cryoProof = cryoProof;
    }

    public boolean isPlasmaProof() {
        return this.plasmaProof;
    }

    public void setPlasmaProof(boolean plasmaProof) {
        this.plasmaProof = plasmaProof;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FluidPipeProperties)) {
            return false;
        }
        FluidPipeProperties that = (FluidPipeProperties)o;
        return this.maxFluidTemperature == that.maxFluidTemperature && this.throughput == that.throughput && this.gasProof == that.gasProof && this.tanks == that.tanks;
    }

    public int hashCode() {
        return Objects.hash(this.maxFluidTemperature, this.throughput, this.gasProof, this.tanks);
    }

    public String toString() {
        return "FluidPipeProperties{maxFluidTemperature=" + this.maxFluidTemperature + ", throughput=" + this.throughput + ", gasProof=" + this.gasProof + ", acidProof=" + this.acidProof + ", cryoProof=" + this.cryoProof + ", plasmaProof=" + this.plasmaProof + ", tanks=" + this.tanks + '}';
    }
}

