/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import javax.annotation.Nullable;

public class IngotProperty
implements IMaterialProperty<IngotProperty> {
    private Material smeltInto;
    private Material arcSmeltInto;
    private Material macerateInto;
    @Nullable
    private Material magneticMaterial;

    public void setSmeltingInto(Material smeltInto) {
        this.smeltInto = smeltInto;
    }

    public Material getSmeltingInto() {
        return this.smeltInto;
    }

    public void setArcSmeltingInto(Material arcSmeltingInto) {
        this.arcSmeltInto = arcSmeltingInto;
    }

    public Material getArcSmeltInto() {
        return this.arcSmeltInto;
    }

    public void setMagneticMaterial(@Nullable Material magneticMaterial) {
        this.magneticMaterial = magneticMaterial;
    }

    @Nullable
    public Material getMagneticMaterial() {
        return this.magneticMaterial;
    }

    public void setMacerateInto(Material macerateInto) {
        this.macerateInto = macerateInto;
    }

    public Material getMacerateInto() {
        return this.macerateInto;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.DUST, true);
        if (properties.hasProperty(PropertyKey.GEM)) {
            throw new IllegalStateException("Material " + properties.getMaterial() + " has both Ingot and Gem Property, which is not allowed!");
        }
        if (this.smeltInto == null) {
            this.smeltInto = properties.getMaterial();
        } else {
            this.smeltInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.arcSmeltInto == null) {
            this.arcSmeltInto = properties.getMaterial();
        } else {
            this.arcSmeltInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.macerateInto == null) {
            this.macerateInto = properties.getMaterial();
        } else {
            this.macerateInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.magneticMaterial != null) {
            this.magneticMaterial.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
    }
}

