/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import crafttweaker.mc1120.data.NBTConverter;
import gregtech.api.block.machines.MachineItemBlock;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.fluids.FluidStack;

public class CTRecipeHelper {
    @Nullable
    public static String getMetaItemId(ItemStack item) {
        if (item.func_77973_b() instanceof MetaItem) {
            MetaItem metaItem = (MetaItem)item.func_77973_b();
            return ((MetaItem.MetaValueItem)metaItem.getItem((ItemStack)item)).unlocalizedName;
        }
        if (item.func_77973_b() instanceof ItemBlock) {
            MetaTileEntity mte;
            Block block = ((ItemBlock)item.func_77973_b()).func_179223_d();
            if (item.func_77973_b() instanceof MachineItemBlock && (mte = GTUtility.getMetaTileEntity(item)) != null) {
                return mte.metaTileEntityId.func_110624_b().equals("gregtech") ? mte.metaTileEntityId.func_110623_a() : mte.metaTileEntityId.toString();
            }
            if (block instanceof BlockCompressed) {
                return "block" + ((BlockCompressed)block).getGtMaterial(item.func_77960_j()).toCamelCaseString();
            }
            if (block instanceof BlockFrame) {
                return "frame" + ((BlockFrame)block).getGtMaterial(item.func_77960_j()).toCamelCaseString();
            }
            if (block instanceof BlockMaterialPipe) {
                return ((BlockMaterialPipe)block).getPrefix().name + ((BlockMaterialPipe)block).getItemMaterial(item).toCamelCaseString();
            }
        }
        return null;
    }

    public static String getItemIdFor(ItemStack item) {
        String id = CTRecipeHelper.getMetaItemId(item);
        if (id != null) {
            return id;
        }
        if (item.func_77973_b().getRegistryName() == null) {
            return "null";
        }
        return item.func_77973_b().getRegistryName().toString();
    }

    public static String getRecipeRemoveLine(RecipeMap<?> recipeMap, Recipe recipe) {
        StringBuilder builder = new StringBuilder();
        builder.append("<recipemap:").append(recipeMap.unlocalizedName).append(">.findRecipe(").append(recipe.getEUt()).append(", ");
        if (recipe.getInputs().size() > 0) {
            builder.append("[");
            for (GTRecipeInput ci : recipe.getInputs()) {
                String ingredient = CTRecipeHelper.getCtItemString(ci);
                if (ingredient == null) continue;
                builder.append(ingredient);
            }
            builder.delete(builder.length() - 2, builder.length()).append("], ");
        } else {
            builder.append("null, ");
        }
        if (recipe.getFluidInputs().size() > 0) {
            builder.append("[");
            for (GTRecipeInput fluidIngredient : recipe.getFluidInputs()) {
                builder.append("<liquid:").append(fluidIngredient.getInputFluidStack().getFluid().getName()).append(">");
                if (fluidIngredient.getAmount() > 1) {
                    builder.append(" * ").append(fluidIngredient.getAmount());
                }
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length()).append("]");
        } else {
            builder.append("null");
        }
        builder.append(").remove();");
        return builder.toString();
    }

    public static String getRecipeAddLine(RecipeMap<?> recipeMap, Recipe recipe) {
        StringBuilder builder = new StringBuilder();
        builder.append(recipeMap.unlocalizedName).append(".recipeBuilder()").append(".inputs(");
        if (recipe.getInputs().size() > 0) {
            builder.append("[");
            for (GTRecipeInput ci : recipe.getInputs()) {
                String ingredient = CTRecipeHelper.getCtItemString(ci);
                if (ingredient == null) continue;
                builder.append(ingredient);
            }
            builder.delete(builder.length() - 2, builder.length()).append("])");
        }
        if (recipe.getFluidInputs().size() > 0) {
            builder.append(".fluidInputs(");
            builder.append("[");
            for (GTRecipeInput fluidStack : recipe.getFluidInputs()) {
                builder.append("<liquid:").append(fluidStack.getInputFluidStack().getFluid().getName()).append(">");
                if (fluidStack.getAmount() > 1) {
                    builder.append(" * ").append(fluidStack.getAmount());
                }
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length()).append("])");
        }
        if (recipe.getOutputs().size() > 0) {
            builder.append(".outputs(");
            builder.append("[");
            for (ItemStack itemStack : recipe.getOutputs()) {
                String nbt;
                String itemId = CTRecipeHelper.getMetaItemId(itemStack);
                if (itemId != null) {
                    builder.append("<metaitem:").append(itemId).append(">");
                } else {
                    builder.append("<").append(itemStack.func_77973_b().getRegistryName().toString()).append(":").append(itemStack.func_77952_i()).append(">");
                }
                if (!itemStack.serializeNBT().func_74764_b("tag") || (nbt = NBTConverter.from((NBTBase)itemStack.serializeNBT().func_74775_l("tag"), (boolean)false).toString()).length() <= 0) continue;
                builder.append(".withTag(").append(nbt).append(")");
            }
            builder.delete(builder.length() - 2, builder.length()).append("])");
        }
        if (recipe.getFluidOutputs().size() > 0) {
            builder.append(".fluidOutputs(");
            builder.append("[");
            for (GTRecipeInput fluidStack : recipe.getFluidOutputs()) {
                builder.append("<liquid:").append(fluidStack.getFluid().getName()).append(">");
                if (((FluidStack)fluidStack).amount <= 1) continue;
                builder.append(" * ").append(((FluidStack)fluidStack).amount);
            }
            builder.delete(builder.length() - 2, builder.length()).append("])");
        }
        builder.append("....");
        return builder.toString();
    }

    public static String getFirstOutputString(Recipe recipe) {
        String output = "";
        if (!recipe.getOutputs().isEmpty()) {
            ItemStack item = (ItemStack)recipe.getOutputs().get(0);
            output = item.func_82833_r() + " * " + item.func_190916_E();
        } else if (!recipe.getFluidOutputs().isEmpty()) {
            FluidStack fluid = recipe.getFluidOutputs().get(0);
            output = fluid.getLocalizedName() + " * " + fluid.amount;
        }
        return output;
    }

    public static String getCtItemString(GTRecipeInput recipeInput) {
        StringBuilder builder = new StringBuilder();
        ItemStack itemStack = null;
        String itemId = null;
        for (ItemStack item : recipeInput.getInputStacks()) {
            itemId = CTRecipeHelper.getMetaItemId(item);
            if (itemId != null) {
                builder.append("<metaitem:").append(itemId).append(">");
                itemStack = item;
                break;
            }
            if (itemStack != null) continue;
            itemStack = item;
        }
        if (itemStack != null) {
            String nbt;
            if (itemId == null) {
                if (itemStack.func_77973_b().getRegistryName() == null) {
                    GTLog.logger.info("Could not remove recipe {}, because of unregistered Item", (Object)builder);
                    return null;
                }
                builder.append("<").append(itemStack.func_77973_b().getRegistryName().toString()).append(":").append(itemStack.func_77952_i()).append(">");
            }
            if (itemStack.serializeNBT().func_74764_b("tag") && (nbt = NBTConverter.from((NBTBase)itemStack.serializeNBT().func_74775_l("tag"), (boolean)false).toString()).length() > 0) {
                builder.append(".withTag(").append(nbt).append(")");
            }
        }
        if (recipeInput.getAmount() > 1) {
            builder.append(" * ").append(recipeInput.getAmount());
        }
        builder.append(", ");
        return builder.toString();
    }
}

