/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import crafttweaker.annotations.ZenRegister;
import gregtech.api.GregTechAPI;
import gregtech.api.util.GTLog;
import gregtech.client.renderer.texture.Textures;
import gregtech.core.network.packets.PacketNotifyCapeChange;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.util.CapesRegistry")
@ZenRegister
public class CapesRegistry {
    private static final Map<UUID, List<ResourceLocation>> UNLOCKED_CAPES = new HashMap<UUID, List<ResourceLocation>>();
    private static final Map<UUID, ResourceLocation> WORN_CAPES = new HashMap<UUID, ResourceLocation>();
    private static final Map<Advancement, ResourceLocation> CAPE_ADVANCEMENTS = new HashMap<Advancement, ResourceLocation>();
    private static List<Tuple<ResourceLocation, ResourceLocation>> ctRegisterCapes = new ArrayList<Tuple<ResourceLocation, ResourceLocation>>();

    public static void registerDevCapes() {
        CapesRegistry.unlockCape(UUID.fromString("2fa297a6-7803-4629-8360-7059155cf43e"), Textures.GREGTECH_CAPE_TEXTURE);
        CapesRegistry.unlockCape(UUID.fromString("a82fb558-64f9-4dd6-a87d-84040e84bb43"), Textures.GREGTECH_CAPE_TEXTURE);
        CapesRegistry.unlockCape(UUID.fromString("5c2933b3-5340-4356-81e7-783c53bd7845"), Textures.GREGTECH_CAPE_TEXTURE);
        CapesRegistry.unlockCape(UUID.fromString("56bd41d0-06ef-4ed7-ab48-926ce45651f9"), Textures.GREGTECH_CAPE_TEXTURE);
        CapesRegistry.unlockCape(UUID.fromString("aaf70ec1-ac70-494f-9966-ea5933712750"), Textures.GREGTECH_CAPE_TEXTURE);
        CapesRegistry.unlockCape(UUID.fromString("a24a9108-23d2-43fc-8db7-43f809d017db"), Textures.GREGTECH_CAPE_TEXTURE);
        CapesRegistry.unlockCape(UUID.fromString("77e2129d-8f68-4025-9394-df946f1f3aee"), Textures.GREGTECH_CAPE_TEXTURE);
        CapesRegistry.save();
    }

    public static ResourceLocation getPlayerCape(UUID uuid) {
        return WORN_CAPES.get(uuid);
    }

    public static void save() {
        NBTTagCompound comp = new NBTTagCompound();
        NBTTagList unlockedCapesTag = new NBTTagList();
        for (Map.Entry<UUID, List<ResourceLocation>> entry : UNLOCKED_CAPES.entrySet()) {
            for (ResourceLocation cape : entry.getValue()) {
                String capeLocation = cape.toString();
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("Cape", capeLocation);
                tag.func_186854_a("UUID", entry.getKey());
                unlockedCapesTag.func_74742_a((NBTBase)tag);
            }
        }
        comp.func_74782_a("UnlockedCapesValList", (NBTBase)unlockedCapesTag);
        NBTTagList wornCapesTag = new NBTTagList();
        for (Map.Entry<UUID, ResourceLocation> entry : WORN_CAPES.entrySet()) {
            if (entry.getValue() == null) continue;
            String capeLocation = entry.getValue().toString();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Cape", capeLocation);
            tag.func_186854_a("UUID", entry.getKey());
            wornCapesTag.func_74742_a((NBTBase)tag);
        }
        comp.func_74782_a("WornCapesValList", (NBTBase)wornCapesTag);
        try {
            CompressedStreamTools.func_74793_a((NBTTagCompound)comp, (File)new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_72860_G().func_75765_b(), "gregtech_cape.dat"));
        }
        catch (IOException iOException) {
            GTLog.logger.error((Object)iOException);
        }
    }

    public static void load() {
        NBTTagCompound comp = null;
        try {
            comp = CompressedStreamTools.func_74797_a((File)new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_72860_G().func_75765_b(), "gregtech_cape.dat"));
        }
        catch (IOException exception) {
            GTLog.logger.error((Object)exception);
        }
        CapesRegistry.clearMaps();
        if (comp == null) {
            CapesRegistry.registerDevCapes();
            return;
        }
        NBTTagList unlockedCapesTag = comp.func_150295_c("UnlockedCapesValList", 10);
        for (int i = 0; i < unlockedCapesTag.func_74745_c(); ++i) {
            NBTTagCompound tag = unlockedCapesTag.func_150305_b(i);
            String capeLocation = tag.func_74779_i("Cape");
            if (capeLocation.isEmpty()) continue;
            UUID uuid = tag.func_186857_a("UUID");
            List<ResourceLocation> capes = UNLOCKED_CAPES.get(uuid);
            if (capes == null) {
                capes = new ArrayList<ResourceLocation>();
            }
            capes.add(new ResourceLocation(capeLocation));
            UNLOCKED_CAPES.put(uuid, capes);
        }
        NBTTagList wornCapesTag = comp.func_150295_c("WornCapesValList", 10);
        for (int i = 0; i < wornCapesTag.func_74745_c(); ++i) {
            NBTTagCompound tag = wornCapesTag.func_150305_b(i);
            String capeLocation = tag.func_74779_i("Cape");
            if (capeLocation.isEmpty()) continue;
            UUID uuid = tag.func_186857_a("UUID");
            WORN_CAPES.put(uuid, new ResourceLocation(capeLocation));
        }
        CapesRegistry.registerDevCapes();
    }

    public static void checkAdvancements(World world) {
        CapesRegistry.registerCape(new ResourceLocation("gregtech", "ultimate_voltage/74_wetware_mainframe"), Textures.GREGTECH_CAPE_TEXTURE, world);
        CapesRegistry.registerCape(new ResourceLocation("gregtech", "steam/12_electronic_circuit"), Textures.RED_CAPE_TEXTURE, world);
        CapesRegistry.registerCape(new ResourceLocation("gregtech", "high_voltage/82_large_chemical_reactor"), Textures.YELLOW_CAPE_TEXTURE, world);
        CapesRegistry.registerCape(new ResourceLocation("gregtech", "ludicrous_voltage/60_fusion"), Textures.GREEN_CAPE_TEXTURE, world);
        for (Tuple<ResourceLocation, ResourceLocation> tuple : ctRegisterCapes) {
            CapesRegistry.registerCape((ResourceLocation)tuple.func_76341_a(), (ResourceLocation)tuple.func_76340_b(), world);
        }
    }

    public static List<ResourceLocation> getUnlockedCapes(UUID uuid) {
        return UNLOCKED_CAPES.getOrDefault(uuid, Collections.emptyList());
    }

    public static void registerCape(ResourceLocation advancement, ResourceLocation cape, World world) {
        AdvancementManager advManager;
        Advancement advObject;
        if (!world.field_72995_K && (advObject = (advManager = (AdvancementManager)ObfuscationReflectionHelper.getPrivateValue(World.class, (Object)world, (String)"field_191951_C")).func_192778_a(advancement)) != null) {
            CAPE_ADVANCEMENTS.put(advObject, cape);
        }
    }

    @Optional.Method(modid="crafttweaker")
    @ZenMethod
    public static void registerCape(String advancement, String cape) {
        ctRegisterCapes.add((Tuple<ResourceLocation, ResourceLocation>)new Tuple((Object)new ResourceLocation(advancement), (Object)new ResourceLocation(cape)));
    }

    public static void unlockCape(UUID uuid, ResourceLocation cape) {
        List<ResourceLocation> capes = UNLOCKED_CAPES.get(uuid);
        if (capes == null) {
            capes = new ArrayList<ResourceLocation>();
        } else if (capes.contains(cape)) {
            return;
        }
        capes.add(cape);
        UNLOCKED_CAPES.put(uuid, capes);
    }

    public static void unlockCapeOnAdvancement(EntityPlayer player, Advancement advancement) {
        if (CAPE_ADVANCEMENTS.containsKey(advancement)) {
            CapesRegistry.unlockCape(player.getPersistentID(), CAPE_ADVANCEMENTS.get(advancement));
            player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.chat.cape", new Object[0]));
            CapesRegistry.save();
        }
    }

    public static void clearMaps() {
        UNLOCKED_CAPES.clear();
        WORN_CAPES.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public static void giveRawCape(UUID uuid, ResourceLocation cape) {
        WORN_CAPES.put(uuid, cape);
    }

    public static void giveCape(UUID uuid, ResourceLocation cape) {
        WORN_CAPES.put(uuid, cape);
        GregTechAPI.networkHandler.sendToAll(new PacketNotifyCapeChange(uuid, cape));
        CapesRegistry.save();
    }

    public static void loadWornCapeOnLogin(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            UUID uuid = player.getPersistentID();
            GregTechAPI.networkHandler.sendToAll(new PacketNotifyCapeChange(uuid, WORN_CAPES.get(uuid)));
            for (EntityPlayerMP otherPlayer : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                uuid = otherPlayer.getPersistentID();
                GregTechAPI.networkHandler.sendTo(new PacketNotifyCapeChange(uuid, WORN_CAPES.get(uuid)), (EntityPlayerMP)player);
            }
        }
    }

    public static void detectNewCapes(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            for (Map.Entry<Advancement, ResourceLocation> capeEntry : CAPE_ADVANCEMENTS.entrySet()) {
                if (UNLOCKED_CAPES.get(player.getPersistentID()) != null && UNLOCKED_CAPES.get(player.getPersistentID()).contains(capeEntry.getValue()) || !((EntityPlayerMP)player).func_192039_O().func_192747_a(capeEntry.getKey()).func_192105_a()) continue;
                CapesRegistry.unlockCapeOnAdvancement(player, capeEntry.getKey());
            }
        }
    }
}

