/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import gregtech.api.util.GTLog;
import gregtech.api.worldgen.config.WorldGenRegistry;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class FileUtility {
    public static final JsonParser jsonParser = new JsonParser();
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private FileUtility() {
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        byte[] streamData = IOUtils.toByteArray((InputStream)inputStream);
        return new String(streamData, StandardCharsets.UTF_8);
    }

    public static InputStream writeInputStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject tryExtractFromFile(Path filePath) {
        try (InputStream fileStream = Files.newInputStream(filePath, new OpenOption[0]);){
            InputStreamReader streamReader = new InputStreamReader(fileStream);
            JsonObject jsonObject = jsonParser.parse((Reader)streamReader).getAsJsonObject();
            return jsonObject;
        }
        catch (IOException exception) {
            GTLog.logger.error("Failed to read file on path {}", (Object)filePath, (Object)exception);
            return null;
        }
        catch (JsonParseException exception) {
            GTLog.logger.error("Failed to extract json from file", (Throwable)exception);
            return null;
        }
        catch (Exception exception) {
            GTLog.logger.error("Failed to extract json from file on path {}", (Object)filePath, (Object)exception);
        }
        return null;
    }

    public static JsonElement loadJson(File file) {
        try {
            if (!file.isFile()) {
                return null;
            }
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            JsonElement json = jsonParser.parse(new JsonReader((Reader)reader));
            ((Reader)reader).close();
            return json;
        }
        catch (Exception e) {
            GTLog.logger.error("Failed to read file on path {}", (Object)file, (Object)e);
            return null;
        }
    }

    public static boolean saveJson(File file, JsonElement element) {
        try {
            if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
                GTLog.logger.error("Failed to create file dirs on path {}", (Object)file);
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            writer.write(gson.toJson(element));
            ((Writer)writer).close();
            return true;
        }
        catch (Exception e) {
            GTLog.logger.error("Failed to save file on path {}", (Object)file, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractJarFiles(String resource, File targetPath, boolean replace) {
        FileSystem zipFileSystem = null;
        try {
            Path resourcePath;
            URI sampleUri = WorldGenRegistry.class.getResource("/assets/gregtech/.gtassetsroot").toURI();
            if (sampleUri.getScheme().equals("jar") || sampleUri.getScheme().equals("zip")) {
                zipFileSystem = FileSystems.newFileSystem(sampleUri, Collections.emptyMap());
                resourcePath = zipFileSystem.getPath(resource, new String[0]);
            } else {
                if (!sampleUri.getScheme().equals("file")) throw new IllegalStateException("Unable to locate absolute path to directory: " + sampleUri);
                resourcePath = Paths.get(WorldGenRegistry.class.getResource(resource).toURI());
            }
            List jarFiles = Files.walk(resourcePath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
            for (Path jarFile : jarFiles) {
                Path genPath = targetPath.toPath().resolve(resourcePath.relativize(jarFile).toString());
                Files.createDirectories(genPath.getParent(), new FileAttribute[0]);
                if (!replace && genPath.toFile().isFile()) continue;
                Files.copy(jarFile, genPath, StandardCopyOption.REPLACE_EXISTING);
            }
            if (zipFileSystem == null) return;
        }
        catch (URISyntaxException impossible) {
            throw new RuntimeException(impossible);
            catch (IOException exception) {
                GTLog.logger.error("error while extracting jar files: {} {}", (Object)resource, (Object)targetPath, (Object)exception);
                return;
            }
        }
        IOUtils.closeQuietly((Closeable)zipFileSystem);
        return;
        finally {
            if (zipFileSystem != null) {
                IOUtils.closeQuietly(zipFileSystem);
            }
        }
    }
}

