/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.GTLog;
import gregtech.api.util.world.DummyWorld;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModCompatibility {
    private static RefinedStorage refinedStorage;

    public static void initCompat() {
        try {
            Class<?> itemClass = Class.forName("com.raoulvdberge.refinedstorage.item.ItemPattern");
            refinedStorage = new RefinedStorage(itemClass);
            GTLog.logger.info("RefinedStorage found; enabling integration.");
        }
        catch (ClassNotFoundException ignored) {
            GTLog.logger.info("RefinedStorage not found; skipping integration.");
        }
        catch (Throwable exception) {
            GTLog.logger.error("Failed to enable RefinedStorage integration", exception);
        }
    }

    public static ItemStack getRealItemStack(ItemStack itemStack) {
        if (refinedStorage != null && refinedStorage.canHandleItemStack(itemStack)) {
            return refinedStorage.getRealItemStack(itemStack);
        }
        return itemStack;
    }

    private static class RefinedStorage {
        private final Method getPatternFromCacheMethod;
        private final Method getOutputsMethod;

        public RefinedStorage(Class<?> itemPatternClass) throws ReflectiveOperationException {
            this.getPatternFromCacheMethod = itemPatternClass.getMethod("getPatternFromCache", World.class, ItemStack.class);
            this.getOutputsMethod = this.getPatternFromCacheMethod.getReturnType().getMethod("getOutputs", new Class[0]);
        }

        public boolean canHandleItemStack(ItemStack itemStack) {
            ResourceLocation registryName = Objects.requireNonNull(itemStack.func_77973_b().getRegistryName());
            return registryName.func_110624_b().equals("refinedstorage") && registryName.func_110623_a().equals("pattern");
        }

        public ItemStack getRealItemStack(ItemStack itemStack) {
            try {
                Object craftingPattern = this.getPatternFromCacheMethod.invoke(null, new Object[]{DummyWorld.INSTANCE, itemStack});
                List outputs = (List)this.getOutputsMethod.invoke(craftingPattern, new Object[0]);
                return outputs.isEmpty() ? itemStack : (ItemStack)outputs.get(0);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to obtain item from ItemPattern", ex);
            }
        }
    }
}

