/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.particle.DigIconParticle;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import gregtech.api.GTValues;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleHandlerUtil {
    public static void addBlockRunningEffects(World worldObj, Entity entity, TextureAtlasSprite atlasSprite, int spriteColor) {
        if (atlasSprite == null) {
            return;
        }
        double posX = entity.field_70165_t + ((double)GTValues.RNG.nextFloat() - 0.5) * (double)entity.field_70130_N;
        double posY = entity.func_174813_aQ().field_72338_b + 0.1;
        double posZ = entity.field_70161_v + ((double)GTValues.RNG.nextFloat() - 0.5) * (double)entity.field_70130_N;
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        float red = (float)(spriteColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(spriteColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(spriteColor & 0xFF) / 255.0f;
        DigIconParticle digIconParticle = new DigIconParticle(worldObj, posX, posY, posZ, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, atlasSprite);
        digIconParticle.func_70538_b(red, green, blue);
        manager.func_78873_a((Particle)digIconParticle);
    }

    public static void addBlockLandingEffects(World worldObj, Vector3 entityPos, TextureAtlasSprite atlasSprite, int spriteColor, ParticleManager manager, int numParticles) {
        if (atlasSprite == null) {
            return;
        }
        Vector3 start = entityPos.copy();
        Vector3 end = start.copy().add(Vector3.down.copy().multiply(4.0));
        RayTraceResult traceResult = worldObj.func_147447_a(start.vec3(), end.vec3(), true, false, true);
        double speed = 0.15;
        float red = (float)(spriteColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(spriteColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(spriteColor & 0xFF) / 255.0f;
        if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK && numParticles != 0) {
            for (int i = 0; i < numParticles; ++i) {
                double mX = GTValues.RNG.nextGaussian() * speed;
                double mY = GTValues.RNG.nextGaussian() * speed;
                double mZ = GTValues.RNG.nextGaussian() * speed;
                DigIconParticle digIconParticle = DigIconParticle.newLandingParticle((World)worldObj, (double)entityPos.x, (double)entityPos.y, (double)entityPos.z, (double)mX, (double)mY, (double)mZ, (TextureAtlasSprite)atlasSprite);
                digIconParticle.func_70538_b(red, green, blue);
                manager.func_78873_a((Particle)digIconParticle);
            }
        }
    }

    public static void addBlockDestroyEffects(World worldObj, CuboidRayTraceResult result, TextureAtlasSprite atlasSprite, int spriteColor, ParticleManager manager) {
        ParticleHandlerUtil.addBlockDestroyEffects(worldObj, (Cuboid6)result.cuboid6, atlasSprite, spriteColor, manager);
    }

    public static void addBlockDestroyEffects(IBlockState blockState, World worldObj, BlockPos blockPos, TextureAtlasSprite atlasSprite, int spriteColor, ParticleManager manager) {
        Cuboid6 cuboid6 = new Cuboid6(blockState.func_185900_c((IBlockAccess)worldObj, blockPos)).add(blockPos);
        ParticleHandlerUtil.addBlockDestroyEffects(worldObj, cuboid6, atlasSprite, spriteColor, manager);
    }

    public static void addHitEffects(World worldObj, CuboidRayTraceResult result, TextureAtlasSprite atlasSprite, int spriteColor, ParticleManager manager) {
        ParticleHandlerUtil.addBlockHitEffects(worldObj, (Cuboid6)result.cuboid6, result.field_178784_b, atlasSprite, spriteColor, manager);
    }

    public static void addHitEffects(IBlockState blockState, World worldObj, RayTraceResult target, TextureAtlasSprite atlasSprite, int spriteColor, ParticleManager manager) {
        Cuboid6 cuboid6 = ParticleHandlerUtil.getBoundingBox(blockState, worldObj, target);
        ParticleHandlerUtil.addBlockHitEffects(worldObj, cuboid6, target.field_178784_b, atlasSprite, spriteColor, manager);
    }

    private static Cuboid6 getBoundingBox(IBlockState blockState, World world, RayTraceResult target) {
        BlockPos blockPos = target.func_178782_a();
        if (target instanceof CuboidRayTraceResult) {
            return ((CuboidRayTraceResult)target).cuboid6.copy().add(blockPos);
        }
        return new Cuboid6(blockState.func_185900_c((IBlockAccess)world, blockPos)).add(blockPos);
    }

    public static void addBlockHitEffects(World world, Cuboid6 bounds, EnumFacing side, TextureAtlasSprite icon, int spriteColor, ParticleManager particleManager) {
        if (icon == null) {
            return;
        }
        float border = 0.1f;
        Vector3 diff = bounds.max.copy().subtract(bounds.min).add((double)(-2.0f * border));
        diff.x *= world.field_73012_v.nextDouble();
        diff.y *= world.field_73012_v.nextDouble();
        diff.z *= world.field_73012_v.nextDouble();
        Vector3 pos = diff.add(bounds.min).add((double)border);
        float red = (float)(spriteColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(spriteColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(spriteColor & 0xFF) / 255.0f;
        if (side == EnumFacing.DOWN) {
            diff.y = bounds.min.y - (double)border;
        }
        if (side == EnumFacing.UP) {
            diff.y = bounds.max.y + (double)border;
        }
        if (side == EnumFacing.NORTH) {
            diff.z = bounds.min.z - (double)border;
        }
        if (side == EnumFacing.SOUTH) {
            diff.z = bounds.max.z + (double)border;
        }
        if (side == EnumFacing.WEST) {
            diff.x = bounds.min.x - (double)border;
        }
        if (side == EnumFacing.EAST) {
            diff.x = bounds.max.x + (double)border;
        }
        DigIconParticle digIconParticle = new DigIconParticle(world, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0, icon);
        digIconParticle.func_70543_e(0.2f);
        digIconParticle.func_70541_f(0.6f);
        digIconParticle.func_70538_b(red, green, blue);
        particleManager.func_78873_a((Particle)digIconParticle);
    }

    public static void addBlockDestroyEffects(World world, Cuboid6 bounds, TextureAtlasSprite icon, int spriteColor, ParticleManager particleManager) {
        if (icon == null) {
            return;
        }
        Vector3 diff = bounds.max.copy().subtract(bounds.min);
        Vector3 center = bounds.min.copy().add(bounds.max).multiply(0.5);
        Vector3 density = diff.copy().multiply(4.0).ceil();
        float red = (float)(spriteColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(spriteColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(spriteColor & 0xFF) / 255.0f;
        int i = 0;
        while ((double)i < density.x) {
            int j = 0;
            while ((double)j < density.y) {
                int k = 0;
                while ((double)k < density.z) {
                    double x = bounds.min.x + ((double)i + 0.5) * diff.x / density.x;
                    double y = bounds.min.y + ((double)j + 0.5) * diff.y / density.y;
                    double z = bounds.min.z + ((double)k + 0.5) * diff.z / density.z;
                    DigIconParticle digIconParticle = new DigIconParticle(world, x, y, z, x - center.x, y - center.y, z - center.z, icon);
                    digIconParticle.func_70538_b(red, green, blue);
                    particleManager.func_78873_a((Particle)digIconParticle);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

