/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.shape;

import com.google.gson.JsonObject;
import gregtech.api.worldgen.config.OreConfigUtils;
import gregtech.api.worldgen.shape.IBlockGeneratorAccess;
import gregtech.api.worldgen.shape.ShapeGenerator;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.ArrayUtils;

public class SingleBlockGenerator
extends ShapeGenerator {
    private int minBlocksCount;
    private int maxBlocksCount;

    public SingleBlockGenerator() {
    }

    public SingleBlockGenerator(int minBlocksCount, int maxBlocksCount) {
        this.minBlocksCount = minBlocksCount;
        this.maxBlocksCount = maxBlocksCount;
    }

    @Override
    public void loadFromConfig(JsonObject object) {
        int[] blocksCount = OreConfigUtils.getIntRange(object.get("blocks_count"));
        this.minBlocksCount = blocksCount[0];
        this.maxBlocksCount = blocksCount[1];
    }

    @Override
    public Vec3i getMaxSize() {
        return new Vec3i(this.maxBlocksCount, this.maxBlocksCount, this.maxBlocksCount);
    }

    @Override
    public void generate(Random gridRandom, IBlockGeneratorAccess relativeBlockAccess) {
        BlockPos.MutableBlockPos relativePos = new BlockPos.MutableBlockPos();
        int blocksCount = this.minBlocksCount == this.maxBlocksCount ? this.maxBlocksCount : this.minBlocksCount + gridRandom.nextInt(this.maxBlocksCount - this.minBlocksCount);
        EnumFacing prevDirection = null;
        for (int i = 0; i < blocksCount; ++i) {
            EnumFacing[] allowedFacings = (EnumFacing[])ArrayUtils.removeElement((Object[])EnumFacing.field_82609_l, prevDirection);
            prevDirection = allowedFacings[gridRandom.nextInt(allowedFacings.length)];
            relativePos.func_177972_a(prevDirection);
            relativeBlockAccess.generateBlock(relativePos.func_177958_n(), relativePos.func_177956_o(), relativePos.func_177952_p());
        }
    }
}

