/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import codechicken.lib.vec.Cuboid6;
import gregtech.api.GTValues;
import gregtech.client.particle.GTParticle;
import gregtech.client.shader.postprocessing.BloomEffect;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.RenderBufferHelper;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GTOverheatParticle
extends GTParticle {
    public static final int[] blackBodyColors = new int[]{0xFF3300, 16732928, 16737536, 16741120, 16743936, 16746770, 16749356, 16751935, 16753999, 16756062, 16757867, 16759672, 16761220, 16762767, 0xFFCC99, 16765347, 16766381, 16767414, 16768446, 16769478, 16770254, 16771285, 16772060, 0xFFEEE3, 16773353, 0xFFF3EF, 0xFFF5F5, 0xFFF8FB, 0xFEF9FF, 0xF9F6FF, 0xF5F3FF, 0xF0F1FF, 0xEDEFFF, 15330815, 15133695, 14936575, 14739455, 14542591, 14345471, 14214143, 14082559, 13885695, 0xD1DFFF, 0xCFDDFF, 13556991, 13425663, 13294335, 13228543, 13097215, 13031679, 12900351, 12834559, 12768767, 12702975, 12637439, 12571647, 12505855, 12440319, 12374527, 12308991, 12243199, 12177663, 12111871, 12046335, 12046079, 11980543, 11914751, 11914751, 11848959, 11783423, 11783423, 11717631, 11717631, 11651839, 11651839, 11586303, 11520511, 11520511, 11520511, 11454975, 11454719, 11389183, 11389183, 11323391, 11323391, 11323391, 11257855, 11257599, 11192063, 11192063, 11192063, 11126527, 11126271, 11126271, 11126271, 11060735};
    protected final int meltTemp;
    protected int temperature = 293;
    protected final BlockPos pos;
    protected List<Cuboid6> pipeBoxes;
    protected boolean insulated;
    protected float alpha = 0.0f;
    protected int color = blackBodyColors[0];
    static BloomEffectUtil.IBloomRenderFast RENDER_HANDLER = new BloomEffectUtil.IBloomRenderFast(){
        float lastBrightnessX;
        float lastBrightnessY;

        @Override
        public int customBloomStyle() {
            return ConfigHolder.client.shader.heatEffectBloom.useShader ? ConfigHolder.client.shader.heatEffectBloom.bloomStyle : -1;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void preDraw(BufferBuilder buffer) {
            BloomEffect.strength = (float)ConfigHolder.client.shader.heatEffectBloom.strength;
            BloomEffect.baseBrightness = (float)ConfigHolder.client.shader.heatEffectBloom.baseBrightness;
            BloomEffect.highBrightnessThreshold = (float)ConfigHolder.client.shader.heatEffectBloom.highBrightnessThreshold;
            BloomEffect.lowBrightnessThreshold = (float)ConfigHolder.client.shader.heatEffectBloom.lowBrightnessThreshold;
            BloomEffect.step = 1.0f;
            this.lastBrightnessX = OpenGlHelper.lastBrightnessX;
            this.lastBrightnessY = OpenGlHelper.lastBrightnessY;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179090_x();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void postDraw(BufferBuilder buffer) {
            GlStateManager.func_179098_w();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.lastBrightnessX, (float)this.lastBrightnessY);
        }
    };

    public static int getBlackBodyColor(int temperature) {
        if (temperature < 1000) {
            return blackBodyColors[0];
        }
        int index = (temperature - 1000) / 200;
        if (index >= blackBodyColors.length - 1) {
            return blackBodyColors[blackBodyColors.length - 1];
        }
        int color = blackBodyColors[index];
        return RenderUtil.colorInterpolator(color, blackBodyColors[index + 1]).apply(Float.valueOf((float)(temperature % 200) / 200.0f));
    }

    public GTOverheatParticle(World worldIn, BlockPos pos, int meltTemp, List<Cuboid6> pipeBoxes, boolean insulated) {
        super(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.pos = pos;
        this.meltTemp = meltTemp;
        this.updatePipeBoxes(pipeBoxes);
        this.insulated = insulated;
        this.motionless = true;
    }

    public void updatePipeBoxes(List<Cuboid6> pipeBoxes) {
        this.pipeBoxes = pipeBoxes;
        for (Cuboid6 cuboid : this.pipeBoxes) {
            cuboid.expand(0.001);
        }
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
        if (temperature <= 293 || temperature > this.meltTemp) {
            this.func_187112_i();
            return;
        }
        if (temperature < 500) {
            this.alpha = 0.0f;
        } else if (temperature < 1000) {
            this.alpha = ((float)temperature - 500.0f) / 500.0f;
            this.alpha = (float)((double)this.alpha * 0.8);
        } else {
            this.alpha = 0.8f;
        }
        this.color = GTOverheatParticle.getBlackBodyColor(temperature);
    }

    @Override
    public void func_189213_a() {
        TileEntity te = this.field_187122_b.func_175625_s(this.pos);
        if (!(te instanceof TileEntityCable) || !((TileEntityCable)te).isParticleAlive()) {
            this.func_187112_i();
            return;
        }
        if (this.temperature > 400 && (double)GTValues.RNG.nextFloat() < 0.04) {
            this.spawnSmoke();
        }
    }

    private void spawnSmoke() {
        float xPos = (float)this.pos.func_177958_n() + 0.5f;
        float yPos = (float)this.pos.func_177956_o() + 0.9f;
        float zPos = (float)this.pos.func_177952_p() + 0.5f;
        float ySpd = 0.3f + 0.1f * GTValues.RNG.nextFloat();
        this.field_187122_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)xPos, (double)yPos, (double)zPos, 0.0, (double)ySpd, 0.0, new int[0]);
    }

    @Override
    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.insulated) {
            return;
        }
        BloomEffectUtil.requestCustomBloom(RENDER_HANDLER, buffer1 -> {
            float red = this.color >> 16 & 0xFF;
            float green = this.color >> 8 & 0xFF;
            float blue = this.color & 0xFF;
            red /= 255.0f;
            green /= 255.0f;
            blue /= 255.0f;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179137_b((double)(this.field_187126_f - field_70556_an), (double)(this.field_187127_g - field_70554_ao), (double)(this.field_187128_h - field_70555_ap));
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (Cuboid6 cuboid : this.pipeBoxes) {
                RenderBufferHelper.renderCubeFace(bufferbuilder, cuboid, red, green, blue, this.alpha, true);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        });
    }
}

