/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.handler;

import gregtech.client.renderer.handler.PortalModel;
import gregtech.common.entities.PortalEntity;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PortalRenderer
extends Render<PortalEntity> {
    private static final ResourceLocation texture = new ResourceLocation("gregtech", "textures/entity/gtportal.png");
    protected PortalModel model = new PortalModel();

    public PortalRenderer(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(PortalEntity entity) {
        return texture;
    }

    public void doRender(PortalEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        this.setupTranslation(x, y, z);
        this.func_180548_c(entity);
        float scaleX = 0.0625f;
        float scaleY = 0.0625f;
        float scaleZ = 0.0625f;
        float translateY = 0.0f;
        if (entity.isOpening()) {
            if (entity.getTimeToDespawn() <= 195) {
                scaleY *= MathHelper.func_76131_a((float)((195.0f - (float)entity.getTimeToDespawn() + partialTicks) / 5.0f), (float)0.05f, (float)1.0f);
                translateY = 0.5f * (1.0f - MathHelper.func_76131_a((float)((195.0f - (float)entity.getTimeToDespawn() + partialTicks) / 5.0f), (float)0.0f, (float)1.0f));
            } else {
                scaleX *= MathHelper.func_76131_a((float)((200.0f - (float)entity.getTimeToDespawn() + partialTicks) / 5.0f), (float)0.05f, (float)1.0f);
                scaleY *= 0.05f;
                scaleZ *= MathHelper.func_76131_a((float)((200.0f - (float)entity.getTimeToDespawn() + partialTicks) / 5.0f), (float)0.05f, (float)1.0f);
                translateY = 0.5f;
            }
        } else if (entity.isClosing()) {
            if (entity.getTimeToDespawn() >= 5) {
                scaleY *= MathHelper.func_76131_a((float)(((float)entity.getTimeToDespawn() - partialTicks - 5.0f) / 5.0f), (float)0.05f, (float)1.0f);
                translateY = 0.5f * (1.0f - MathHelper.func_76131_a((float)(((float)entity.getTimeToDespawn() - partialTicks - 5.0f) / 5.0f), (float)0.0f, (float)1.0f));
            } else {
                scaleX *= MathHelper.func_76131_a((float)(((float)entity.getTimeToDespawn() - partialTicks) / 5.0f), (float)0.05f, (float)1.0f);
                scaleY *= 0.05f;
                scaleZ *= MathHelper.func_76131_a((float)(((float)entity.getTimeToDespawn() - partialTicks) / 5.0f), (float)0.05f, (float)1.0f);
                translateY = 0.5f;
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)translateY, (float)0.0f);
        GlStateManager.func_179152_a((float)scaleX, (float)scaleY, (float)scaleZ);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179114_b((float)(-entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        this.model.func_78088_a(entity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    public void setupTranslation(double x, double y, double z) {
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 0.5f), (float)((float)z));
    }
}

