/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.cube;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import gregtech.api.gui.resources.ResourceHelper;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class OrientedOverlayRenderer
implements ICubeRenderer {
    protected final String basePath;
    protected final OverlayFace[] faces;
    @SideOnly(value=Side.CLIENT)
    public Map<OverlayFace, ActivePredicate> sprites;

    public OrientedOverlayRenderer(String basePath, OverlayFace ... faces) {
        this.basePath = basePath;
        this.faces = faces;
        Textures.CUBE_RENDERER_REGISTRY.put(basePath, this);
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.sprites = new EnumMap<OverlayFace, ActivePredicate>(OverlayFace.class);
        String modID = "gregtech";
        String basePath = this.basePath;
        String[] split = this.basePath.split(":");
        if (split.length == 2) {
            modID = split[0];
            basePath = split[1];
        }
        for (OverlayFace overlayFace : this.faces) {
            String faceName = overlayFace.name().toLowerCase();
            ResourceLocation normalLocation = new ResourceLocation(modID, String.format("blocks/%s/overlay_%s", basePath, faceName));
            TextureAtlasSprite normalSprite = textureMap.func_174942_a(normalLocation);
            ResourceLocation activeLocation = new ResourceLocation(modID, String.format("blocks/%s/overlay_%s_active", basePath, faceName));
            TextureAtlasSprite activeSprite = textureMap.func_174942_a(activeLocation);
            ResourceLocation pausedLocation = new ResourceLocation(modID, String.format("blocks/%s/overlay_%s_paused", basePath, faceName));
            TextureAtlasSprite pausedSprite = ResourceHelper.isTextureExist(pausedLocation) ? textureMap.func_174942_a(pausedLocation) : null;
            ResourceLocation normalLocationEmissive = new ResourceLocation(modID, String.format("blocks/%s/overlay_%s_emissive", basePath, faceName));
            TextureAtlasSprite normalSpriteEmissive = ResourceHelper.isTextureExist(normalLocationEmissive) ? textureMap.func_174942_a(normalLocationEmissive) : null;
            ResourceLocation activeLocationEmissive = new ResourceLocation(modID, String.format("blocks/%s/overlay_%s_active_emissive", basePath, faceName));
            TextureAtlasSprite activeSpriteEmissive = ResourceHelper.isTextureExist(activeLocationEmissive) ? textureMap.func_174942_a(activeLocationEmissive) : null;
            ResourceLocation pausedLocationEmissive = new ResourceLocation(modID, String.format("blocks/%s/overlay_%s_paused_emissive", basePath, faceName));
            TextureAtlasSprite pausedSpriteEmissive = ResourceHelper.isTextureExist(pausedLocationEmissive) ? textureMap.func_174942_a(pausedLocationEmissive) : null;
            this.sprites.put(overlayFace, new ActivePredicate(normalSprite, activeSprite, pausedSprite, normalSpriteEmissive, activeSpriteEmissive, pausedSpriteEmissive));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleSprite() {
        for (ActivePredicate predicate : this.sprites.values()) {
            TextureAtlasSprite sprite;
            if (predicate == null || (sprite = predicate.getSprite(false, false)) == null) continue;
            return sprite;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOrientedState(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds, EnumFacing frontFacing, boolean isActive, boolean isWorkingEnabled) {
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            ActivePredicate predicate = this.sprites.get((Object)OverlayFace.bySide(renderSide, frontFacing));
            if (predicate == null) continue;
            TextureAtlasSprite renderSprite = predicate.getSprite(isActive, isWorkingEnabled);
            Matrix4 renderTranslation = translation.copy();
            Rotation rotation = new Rotation(0.0, 0.0, 1.0, 0.0);
            if (renderSide == EnumFacing.UP || renderSide == EnumFacing.DOWN) {
                if (frontFacing == EnumFacing.NORTH) {
                    renderTranslation.translate(1.0, 0.0, 1.0);
                    rotation = new Rotation(Math.PI, 0.0, 1.0, 0.0);
                } else if (frontFacing == EnumFacing.EAST) {
                    renderTranslation.translate(0.0, 0.0, 1.0);
                    rotation = new Rotation(1.5707963267948966, 0.0, 1.0, 0.0);
                } else if (frontFacing == EnumFacing.WEST) {
                    renderTranslation.translate(1.0, 0.0, 0.0);
                    rotation = new Rotation(-1.5707963267948966, 0.0, 1.0, 0.0);
                }
                renderTranslation = RenderUtil.adjustTrans(renderTranslation, renderSide, 1);
                renderTranslation.apply((Transformation)rotation);
            }
            Textures.renderFace(renderState, renderTranslation, (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{rotation}), renderSide, bounds, renderSprite, BlockRenderLayer.CUTOUT_MIPPED);
            TextureAtlasSprite emissiveSprite = predicate.getEmissiveSprite(isActive, isWorkingEnabled);
            if (emissiveSprite == null) continue;
            if (ConfigHolder.client.machinesEmissiveTextures) {
                IVertexOperation[] lightPipeline = (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new LightMapOperation(240, 240), rotation});
                Textures.renderFace(renderState, renderTranslation, lightPipeline, renderSide, bounds, emissiveSprite, BloomEffectUtil.getRealBloomLayer());
                continue;
            }
            Textures.renderFace(renderState, renderTranslation, (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{rotation}), renderSide, bounds, emissiveSprite, BlockRenderLayer.CUTOUT_MIPPED);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ActivePredicate {
        private final TextureAtlasSprite normalSprite;
        private final TextureAtlasSprite activeSprite;
        private final TextureAtlasSprite pausedSprite;
        private final TextureAtlasSprite normalSpriteEmissive;
        private final TextureAtlasSprite activeSpriteEmissive;
        private final TextureAtlasSprite pausedSpriteEmissive;

        public ActivePredicate(TextureAtlasSprite normalSprite, TextureAtlasSprite activeSprite, TextureAtlasSprite pausedSprite, TextureAtlasSprite normalSpriteEmissive, TextureAtlasSprite activeSpriteEmissive, TextureAtlasSprite pausedSpriteEmissive) {
            this.normalSprite = normalSprite;
            this.activeSprite = activeSprite;
            this.pausedSprite = pausedSprite;
            this.normalSpriteEmissive = normalSpriteEmissive;
            this.activeSpriteEmissive = activeSpriteEmissive;
            this.pausedSpriteEmissive = pausedSpriteEmissive;
        }

        public TextureAtlasSprite getSprite(boolean active, boolean workingEnabled) {
            if (active) {
                if (workingEnabled) {
                    return this.activeSprite;
                }
                if (this.pausedSprite != null) {
                    return this.pausedSprite;
                }
            }
            return this.normalSprite;
        }

        public TextureAtlasSprite getEmissiveSprite(boolean active, boolean workingEnabled) {
            if (active) {
                if (workingEnabled) {
                    return this.activeSpriteEmissive;
                }
                if (this.pausedSpriteEmissive != null) {
                    return this.pausedSpriteEmissive;
                }
            }
            return this.normalSpriteEmissive;
        }
    }

    public static enum OverlayFace {
        FRONT,
        BACK,
        TOP,
        BOTTOM,
        SIDE;


        public static OverlayFace bySide(EnumFacing side, EnumFacing frontFacing) {
            if (side == frontFacing) {
                return FRONT;
            }
            if (side.func_176734_d() == frontFacing) {
                return BACK;
            }
            if (side == EnumFacing.UP) {
                return TOP;
            }
            if (side == EnumFacing.DOWN) {
                return BOTTOM;
            }
            return SIDE;
        }
    }
}

