/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.custom;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.client.renderer.texture.Textures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class CrateRenderer
implements TextureUtils.IIconRegister {
    private final String basePath;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite sideSprite;

    public CrateRenderer(String basePath) {
        this.basePath = basePath;
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.sideSprite = textureMap.func_174942_a(new ResourceLocation("gregtech", "blocks/" + this.basePath));
    }

    public void render(CCRenderState renderState, Matrix4 translation, int baseColor, IVertexOperation[] pipeline) {
        IVertexOperation[] basePipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(baseColor));
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            Textures.renderFace(renderState, translation, basePipeline, renderSide, Cuboid6.full, this.sideSprite, BlockRenderLayer.CUTOUT_MIPPED);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.sideSprite;
    }
}

