/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import codechicken.lib.vec.Vector3;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.ICoverable;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TaskScheduler;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="gregtech")
public class ToolEventHandlers {
    private static float rColour;
    private static float gColour;
    private static float bColour;

    @SubscribeEvent
    public static void onPlayerDestroyItem(@Nonnull PlayerDestroyItemEvent event) {
        Item item = event.getOriginal().func_77973_b();
        if (item instanceof IGTTool) {
            IGTTool def = (IGTTool)item;
            ItemStack brokenStack = def.getToolStats().getBrokenStack();
            if (brokenStack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null) && def.isElectric()) {
                long remainingCharge = def.getCharge(event.getOriginal());
                IElectricItem electricStack = (IElectricItem)brokenStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
                electricStack.charge(Math.min(remainingCharge, def.getMaxCharge(event.getOriginal())), def.getElectricTier(), true, false);
            }
            if (!brokenStack.func_190926_b()) {
                if (event.getHand() == null) {
                    if (!event.getEntityPlayer().func_191521_c(brokenStack)) {
                        event.getEntityPlayer().func_71019_a(brokenStack, true);
                    }
                } else {
                    event.getEntityPlayer().func_184611_a(event.getHand(), brokenStack);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHarvestDrops(@Nonnull BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        if (player != null) {
            ItemStack stack = player.func_184614_ca();
            if (!stack.func_77942_o()) {
                return;
            }
            if (!event.isSilkTouching()) {
                ToolHelper.applyHammerDropConversion(stack, event.getState(), event.getDrops(), event.getFortuneLevel(), event.getDropChance(), player.func_70681_au());
            }
            NBTTagCompound behaviorTag = ToolHelper.getBehaviorsTag(stack);
            Block block = event.getState().func_177230_c();
            if (!event.isSilkTouching() && (block == Blocks.field_150432_aD || block == Blocks.field_150403_cj) && behaviorTag.func_74767_n("HarvestIce")) {
                Item iceBlock = Item.func_150898_a((Block)block);
                if (event.getDrops().stream().noneMatch(drop -> drop.func_77973_b() == iceBlock)) {
                    event.getDrops().add(new ItemStack(iceBlock));
                    World world = event.getWorld();
                    BlockPos icePos = event.getPos();
                    TaskScheduler.scheduleTask(world, () -> {
                        IBlockState flowingState = world.func_180495_p(icePos);
                        if (flowingState == Blocks.field_150358_i.func_176223_P()) {
                            world.func_175698_g(icePos);
                        }
                        return true;
                    });
                }
            }
            if (behaviorTag.func_74767_n("RelocateMinedBlocks")) {
                event.getDrops().removeIf(arg_0 -> ((EntityPlayer)player).func_191521_c(arg_0));
            }
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_77973_b() instanceof IGTTool && right.func_77973_b() instanceof IGTTool) {
            IGTTool leftTool = (IGTTool)left.func_77973_b();
            IGTTool rightTool = (IGTTool)right.func_77973_b();
            if (leftTool.getToolMaterial(left) != rightTool.getToolMaterial(right)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onDrawHighlightEvent(@Nonnull DrawBlockHighlightEvent event) {
        if (event.getTarget().func_178782_a() == null) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        BlockPos pos = event.getTarget().func_178782_a();
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        TileEntity tile = player.field_70170_p.func_175625_s(event.getTarget().func_178782_a());
        boolean sneaking = player.func_70093_af();
        if (tile != null && ToolEventHandlers.shouldRenderGridOverlays(state, tile, stack, player.func_184592_cb(), sneaking) && ToolEventHandlers.renderGridOverlays(player, pos, state, event.getTarget().field_178784_b, tile, event.getPartialTicks())) {
            event.setCanceled(true);
            return;
        }
        if (!sneaking && stack.func_77973_b() instanceof IGTTool) {
            int damage;
            Set<BlockPos> validPositions = ToolHelper.getHarvestableBlocks(stack, player.field_70170_p, player, event.getTarget());
            if (validPositions.isEmpty()) {
                return;
            }
            float partialTicks = event.getPartialTicks();
            for (BlockPos validPosition : validPositions) {
                event.getContext().func_72731_b(player, new RayTraceResult(Vec3d.field_186680_a, player.func_174811_aO(), validPosition), 0, partialTicks);
            }
            DestroyBlockProgress progress = (DestroyBlockProgress)event.getContext().field_72738_E.get(player.func_145782_y());
            if (progress != null && (damage = progress.func_73106_e()) > -1) {
                double relX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                double relY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                double relZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
                Minecraft mc = Minecraft.func_71410_x();
                BlockRendererDispatcher rendererDispatcher = mc.field_175618_aM;
                ToolEventHandlers.preRenderDamagedBlocks();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                bufferBuilder.func_178969_c(-relX, -relY, -relZ);
                bufferBuilder.func_78914_f();
                for (BlockPos validPosition : validPositions) {
                    TileEntity tileEntity = mc.field_71441_e.func_175625_s(validPosition);
                    if (tileEntity != null && !tileEntity.canRenderBreaking()) continue;
                    TextureAtlasSprite sprite = event.getContext().field_94141_F[damage];
                    rendererDispatcher.func_175020_a(mc.field_71441_e.func_180495_p(validPosition), validPosition, sprite, (IBlockAccess)mc.field_71441_e);
                }
                Tessellator.func_178181_a().func_78381_a();
                bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
                ToolEventHandlers.postRenderDamagedBlocks();
            }
        }
    }

    private static void preRenderDamagedBlocks() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
    }

    @SideOnly(value=Side.CLIENT)
    private static void postRenderDamagedBlocks() {
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SideOnly(value=Side.CLIENT)
    private static boolean shouldRenderGridOverlays(@Nonnull IBlockState state, TileEntity tile, ItemStack mainHand, ItemStack offHand, boolean isSneaking) {
        ICoverable coverable;
        MetaTileEntity mte;
        if (state.func_177230_c() instanceof BlockPipe) {
            BlockPipe pipe = (BlockPipe)state.func_177230_c();
            if (isSneaking && mainHand.func_77973_b().getClass() == Item.func_150898_a((Block)pipe).getClass()) {
                return true;
            }
            Set mainToolClasses = mainHand.func_77973_b().getToolClasses(mainHand);
            Set offToolClasses = offHand.func_77973_b().getToolClasses(offHand);
            if (mainToolClasses.contains("screwdriver")) return true;
            if (offToolClasses.contains("screwdriver")) {
                return true;
            }
            if (mainToolClasses.stream().anyMatch(s -> pipe.isToolEffective((String)s, state))) return true;
            if (offToolClasses.stream().anyMatch(s -> pipe.isToolEffective((String)s, state))) {
                return true;
            }
            BooleanSupplier hasCover = () -> tile instanceof IPipeTile && ((IPipeTile)tile).getCoverableImplementation().hasAnyCover();
            Predicate<CoverDefinition> canCover = coverDef -> tile instanceof IPipeTile && ICoverable.canPlaceCover(coverDef, ((IPipeTile)tile).getCoverableImplementation());
            if (GTUtility.isCoverBehaviorItem(mainHand, hasCover, canCover)) return true;
            if (GTUtility.isCoverBehaviorItem(offHand, hasCover, canCover)) {
                return true;
            }
        }
        if (tile instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)tile).getMetaTileEntity()) != null && mte.canRenderMachineGrid()) {
            if (ToolHelper.isTool(mainHand, "wrench", "screwdriver")) return true;
            if (ToolHelper.isTool(offHand, "wrench", "screwdriver")) {
                return true;
            }
        }
        if ((coverable = (ICoverable)tile.getCapability(GregtechTileCapabilities.CAPABILITY_COVERABLE, null)) == null) return false;
        if (!GTUtility.isCoverBehaviorItem(mainHand, coverable::hasAnyCover, coverDef -> ICoverable.canPlaceCover(coverDef, coverable))) return false;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean renderGridOverlays(@Nonnull EntityPlayer player, BlockPos pos, IBlockState state, EnumFacing facing, TileEntity tile, float partialTicks) {
        if (player.field_70170_p.func_175723_af().func_177746_a(pos)) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            double d3 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double d4 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double d5 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            AxisAlignedBB box = state.func_185918_c(player.field_70170_p, pos).func_186662_g(0.002).func_72317_d(-d3, -d4, -d5);
            RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            gColour = bColour = 0.2f + (float)Math.sin((float)((double)System.currentTimeMillis() % 2513.2741228718346) / 800.0f) / 2.0f;
            rColour = bColour;
            if (tile instanceof TileEntityPipeBase) {
                TileEntityPipeBase tepb = (TileEntityPipeBase)tile;
                ToolEventHandlers.drawGridOverlays(facing, box, face -> tepb.isConnected((EnumFacing)face) || tepb.getCoverableImplementation().getCoverAtSide((EnumFacing)face) != null);
            } else if (tile instanceof MetaTileEntityHolder) {
                MetaTileEntity mte = ((MetaTileEntityHolder)tile).getMetaTileEntity();
                ToolEventHandlers.drawGridOverlays(facing, box, mte::isSideUsed);
            } else {
                ToolEventHandlers.drawGridOverlays(box);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawGridOverlays(@Nonnull AxisAlignedBB box) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        Vector3 topRight = new Vector3(box.field_72336_d, box.field_72337_e, box.field_72334_f);
        Vector3 bottomRight = new Vector3(box.field_72336_d, box.field_72338_b, box.field_72334_f);
        Vector3 bottomLeft = new Vector3(box.field_72340_a, box.field_72338_b, box.field_72334_f);
        Vector3 topLeft = new Vector3(box.field_72340_a, box.field_72337_e, box.field_72334_f);
        Vector3 shift = new Vector3(0.25, 0.0, 0.0);
        Vector3 shiftVert = new Vector3(0.0, 0.25, 0.0);
        Vector3 cubeCenter = new Vector3(box.func_189972_c());
        topRight.subtract(cubeCenter);
        bottomRight.subtract(cubeCenter);
        bottomLeft.subtract(cubeCenter);
        topLeft.subtract(cubeCenter);
        topRight.add(cubeCenter);
        bottomRight.add(cubeCenter);
        bottomLeft.add(cubeCenter);
        topLeft.add(cubeCenter);
        ToolEventHandlers.startLine(buffer, topRight.copy().add(shift.copy().negate()));
        ToolEventHandlers.endLine(buffer, bottomRight.copy().add(shift.copy().negate()));
        ToolEventHandlers.startLine(buffer, bottomLeft.copy().add(shift));
        ToolEventHandlers.endLine(buffer, topLeft.copy().add(shift));
        ToolEventHandlers.startLine(buffer, topLeft.copy().add(shiftVert.copy().negate()));
        ToolEventHandlers.endLine(buffer, topRight.copy().add(shiftVert.copy().negate()));
        ToolEventHandlers.startLine(buffer, bottomLeft.copy().add(shiftVert));
        ToolEventHandlers.endLine(buffer, bottomRight.copy().add(shiftVert));
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawGridOverlays(EnumFacing facing, AxisAlignedBB box, Predicate<EnumFacing> test) {
        boolean bottomBlocked;
        boolean rightBlocked;
        boolean topBlocked;
        boolean leftBlocked;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        Vector3 topRight = new Vector3(box.field_72336_d, box.field_72337_e, box.field_72334_f);
        Vector3 bottomRight = new Vector3(box.field_72336_d, box.field_72338_b, box.field_72334_f);
        Vector3 bottomLeft = new Vector3(box.field_72340_a, box.field_72338_b, box.field_72334_f);
        Vector3 topLeft = new Vector3(box.field_72340_a, box.field_72337_e, box.field_72334_f);
        Vector3 shift = new Vector3(0.25, 0.0, 0.0);
        Vector3 shiftVert = new Vector3(0.0, 0.25, 0.0);
        Vector3 cubeCenter = new Vector3(box.func_189972_c());
        topRight.subtract(cubeCenter);
        bottomRight.subtract(cubeCenter);
        bottomLeft.subtract(cubeCenter);
        topLeft.subtract(cubeCenter);
        boolean frontBlocked = test.test(facing);
        boolean backBlocked = test.test(facing.func_176734_d());
        switch (facing) {
            case WEST: {
                topRight.rotate(1.5707963267948966, Vector3.down);
                bottomRight.rotate(1.5707963267948966, Vector3.down);
                bottomLeft.rotate(1.5707963267948966, Vector3.down);
                topLeft.rotate(1.5707963267948966, Vector3.down);
                shift.rotate(1.5707963267948966, Vector3.down);
                shiftVert.rotate(1.5707963267948966, Vector3.down);
                leftBlocked = test.test(EnumFacing.NORTH);
                topBlocked = test.test(EnumFacing.UP);
                rightBlocked = test.test(EnumFacing.SOUTH);
                bottomBlocked = test.test(EnumFacing.DOWN);
                break;
            }
            case EAST: {
                topRight.rotate(-1.5707963267948966, Vector3.down);
                bottomRight.rotate(-1.5707963267948966, Vector3.down);
                bottomLeft.rotate(-1.5707963267948966, Vector3.down);
                topLeft.rotate(-1.5707963267948966, Vector3.down);
                shift.rotate(-1.5707963267948966, Vector3.down);
                shiftVert.rotate(-1.5707963267948966, Vector3.down);
                leftBlocked = test.test(EnumFacing.SOUTH);
                topBlocked = test.test(EnumFacing.UP);
                rightBlocked = test.test(EnumFacing.NORTH);
                bottomBlocked = test.test(EnumFacing.DOWN);
                break;
            }
            case NORTH: {
                topRight.rotate(Math.PI, Vector3.down);
                bottomRight.rotate(Math.PI, Vector3.down);
                bottomLeft.rotate(Math.PI, Vector3.down);
                topLeft.rotate(Math.PI, Vector3.down);
                shift.rotate(Math.PI, Vector3.down);
                shiftVert.rotate(Math.PI, Vector3.down);
                leftBlocked = test.test(EnumFacing.EAST);
                topBlocked = test.test(EnumFacing.UP);
                rightBlocked = test.test(EnumFacing.WEST);
                bottomBlocked = test.test(EnumFacing.DOWN);
                break;
            }
            case UP: {
                Vector3 side = new Vector3(1.0, 0.0, 0.0);
                topRight.rotate(-1.5707963267948966, side);
                bottomRight.rotate(-1.5707963267948966, side);
                bottomLeft.rotate(-1.5707963267948966, side);
                topLeft.rotate(-1.5707963267948966, side);
                shift.rotate(-1.5707963267948966, side);
                shiftVert.rotate(-1.5707963267948966, side);
                leftBlocked = test.test(EnumFacing.WEST);
                topBlocked = test.test(EnumFacing.NORTH);
                rightBlocked = test.test(EnumFacing.EAST);
                bottomBlocked = test.test(EnumFacing.SOUTH);
                break;
            }
            case DOWN: {
                Vector3 side = new Vector3(1.0, 0.0, 0.0);
                topRight.rotate(1.5707963267948966, side);
                bottomRight.rotate(1.5707963267948966, side);
                bottomLeft.rotate(1.5707963267948966, side);
                topLeft.rotate(1.5707963267948966, side);
                shift.rotate(1.5707963267948966, side);
                shiftVert.rotate(1.5707963267948966, side);
                leftBlocked = test.test(EnumFacing.WEST);
                topBlocked = test.test(EnumFacing.SOUTH);
                rightBlocked = test.test(EnumFacing.EAST);
                bottomBlocked = test.test(EnumFacing.NORTH);
                break;
            }
            default: {
                leftBlocked = test.test(EnumFacing.WEST);
                topBlocked = test.test(EnumFacing.UP);
                rightBlocked = test.test(EnumFacing.EAST);
                bottomBlocked = test.test(EnumFacing.DOWN);
            }
        }
        topRight.add(cubeCenter);
        bottomRight.add(cubeCenter);
        bottomLeft.add(cubeCenter);
        topLeft.add(cubeCenter);
        ToolEventHandlers.startLine(buffer, topRight.copy().add(shift.copy().negate()));
        ToolEventHandlers.endLine(buffer, bottomRight.copy().add(shift.copy().negate()));
        ToolEventHandlers.startLine(buffer, bottomLeft.copy().add(shift));
        ToolEventHandlers.endLine(buffer, topLeft.copy().add(shift));
        ToolEventHandlers.startLine(buffer, topLeft.copy().add(shiftVert.copy().negate()));
        ToolEventHandlers.endLine(buffer, topRight.copy().add(shiftVert.copy().negate()));
        ToolEventHandlers.startLine(buffer, bottomLeft.copy().add(shiftVert));
        ToolEventHandlers.endLine(buffer, bottomRight.copy().add(shiftVert));
        if (leftBlocked) {
            ToolEventHandlers.startLine(buffer, topLeft.copy().add(shiftVert.copy().negate()));
            ToolEventHandlers.endLine(buffer, bottomLeft.copy().add(shiftVert.copy()).add(shift));
            ToolEventHandlers.startLine(buffer, topLeft.copy().add(shiftVert.copy().negate()).add(shift));
            ToolEventHandlers.endLine(buffer, bottomLeft.copy().add(shiftVert));
        }
        if (topBlocked) {
            ToolEventHandlers.startLine(buffer, topLeft.copy().add(shift));
            ToolEventHandlers.endLine(buffer, topRight.copy().add(shift.copy().negate()).add(shiftVert.copy().negate()));
            ToolEventHandlers.startLine(buffer, topLeft.copy().add(shift).add(shiftVert.copy().negate()));
            ToolEventHandlers.endLine(buffer, topRight.copy().add(shift.copy().negate()));
        }
        if (rightBlocked) {
            ToolEventHandlers.startLine(buffer, topRight.copy().add(shiftVert.copy().negate()));
            ToolEventHandlers.endLine(buffer, bottomRight.copy().add(shiftVert.copy()).add(shift.copy().negate()));
            ToolEventHandlers.startLine(buffer, topRight.copy().add(shiftVert.copy().negate()).add(shift.copy().negate()));
            ToolEventHandlers.endLine(buffer, bottomRight.copy().add(shiftVert));
        }
        if (bottomBlocked) {
            ToolEventHandlers.startLine(buffer, bottomLeft.copy().add(shift));
            ToolEventHandlers.endLine(buffer, bottomRight.copy().add(shift.copy().negate()).add(shiftVert));
            ToolEventHandlers.startLine(buffer, bottomLeft.copy().add(shift).add(shiftVert));
            ToolEventHandlers.endLine(buffer, bottomRight.copy().add(shift.copy().negate()));
        }
        if (frontBlocked) {
            ToolEventHandlers.startLine(buffer, topLeft.copy().add(shift).add(shiftVert.copy().negate()));
            ToolEventHandlers.endLine(buffer, bottomRight.copy().add(shift.copy().negate()).add(shiftVert));
            ToolEventHandlers.startLine(buffer, topRight.copy().add(shift.copy().negate()).add(shiftVert.copy().negate()));
            ToolEventHandlers.endLine(buffer, bottomLeft.copy().add(shift).add(shiftVert));
        }
        if (backBlocked) {
            Vector3 localXShift = new Vector3(0.0, 0.0, 0.0);
            for (int i = 0; i < 2; ++i) {
                Vector3 localXShiftVert = new Vector3(0.0, 0.0, 0.0);
                for (int j = 0; j < 2; ++j) {
                    ToolEventHandlers.startLine(buffer, topLeft.copy().add(localXShift).add(localXShiftVert));
                    ToolEventHandlers.endLine(buffer, topLeft.copy().add(localXShift).add(localXShiftVert).add(shift).subtract(shiftVert));
                    ToolEventHandlers.startLine(buffer, topLeft.copy().add(localXShift).add(localXShiftVert).add(shift));
                    ToolEventHandlers.endLine(buffer, topLeft.copy().add(localXShift).add(localXShiftVert).subtract(shiftVert));
                    localXShiftVert.add(bottomLeft.copy().subtract(topLeft).add(shiftVert));
                }
                localXShift.add(topRight.copy().subtract(topLeft).subtract(shift));
            }
        }
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    private static void startLine(BufferBuilder buffer, Vector3 vec) {
        buffer.func_181662_b(vec.x, vec.y, vec.z).func_181666_a(rColour, gColour, bColour, 0.0f).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    private static void endLine(BufferBuilder buffer, Vector3 vec) {
        buffer.func_181662_b(vec.x, vec.y, vec.z).func_181666_a(rColour, gColour, bColour, 1.0f).func_181675_d();
    }
}

