/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.monitor;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.metatileentity.MetaTileEntityUIFactory;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.client.utils.RenderUtil;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityMonitorScreen;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class WidgetScreenGrid
extends Widget {
    public int x;
    public int y;
    public static final int width = 20;
    public static final int height = 20;
    MetaTileEntityMonitorScreen monitorScreen;
    private int color = -16777216;

    public WidgetScreenGrid(int xPosition, int yPosition, int x, int y) {
        super(new Position(xPosition + x * 20, yPosition + y * 20), new Size(20, 20));
        this.x = x;
        this.y = y;
    }

    public void setScreen(MetaTileEntityMonitorScreen monitorScreen) {
        this.monitorScreen = monitorScreen;
        this.color = monitorScreen != null && monitorScreen.isActive() ? -11573505 : -16777216;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        int color = this.monitorScreen != null && this.monitorScreen.isActive() ? this.monitorScreen.frameColor : this.color;
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + width - 2), (int)(y + height - 2), (int)color);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.monitorScreen != null && this.monitorScreen.isActive()) {
            int x = this.getPosition().x;
            int y = this.getPosition().y;
            int width = this.getSize().width;
            int height = this.getSize().height;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(x + width / 2), (float)(y + height / 2), (float)100.0f);
            GlStateManager.func_179152_a((float)width, (float)height, (float)1.0f);
            RenderUtil.renderRect(-0.5f, -0.5f, this.monitorScreen.scale, this.monitorScreen.scale, 0.0f, -16777216);
            this.monitorScreen.renderScreen(0.0f, null);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            Widget.ClickData clickData = new Widget.ClickData(Mouse.getEventButton(), this.isShiftDown(), this.isCtrlDown());
            this.writeClientAction(1, clickData::writeToBuf);
            this.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1 && this.monitorScreen != null) {
            MetaTileEntityUIFactory.INSTANCE.openUI(this.monitorScreen.getHolder(), (EntityPlayerMP)this.gui.entityPlayer);
        }
    }
}

