/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.armor.ArmorMetaItem;
import gregtech.api.items.armor.ArmorUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.input.KeyBind;
import gregtech.common.items.armor.IJetpack;
import gregtech.common.items.armor.QuarkTechSuite;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancedQuarkTechSuite
extends QuarkTechSuite
implements IJetpack {
    private long timer = 0L;
    private List<Pair<NonNullList<ItemStack>, List<Integer>>> inventoryIndexMap;

    public AdvancedQuarkTechSuite(int energyPerUse, long capacity, int tier) {
        super(EntityEquipmentSlot.CHEST, energyPerUse, capacity, tier);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack item) {
        boolean canShare;
        IElectricItem cont = (IElectricItem)item.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (cont == null) {
            return;
        }
        NBTTagCompound data = GTUtility.getOrCreateNbtCompound(item);
        boolean hoverMode = data.func_74764_b("hover") && data.func_74767_n("hover");
        byte toggleTimer = data.func_74764_b("toggleTimer") ? data.func_74771_c("toggleTimer") : (byte)0;
        boolean bl = canShare = data.func_74764_b("canShare") && data.func_74767_n("canShare");
        if (toggleTimer == 0 && KeyBind.ARMOR_HOVER.isKeyDown(player)) {
            hoverMode = !hoverMode;
            toggleTimer = 5;
            data.func_74757_a("hover", hoverMode);
            if (!world.field_72995_K) {
                if (hoverMode) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.jetpack.hover.enable", new Object[0]), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.jetpack.hover.disable", new Object[0]), true);
                }
            }
        }
        if (toggleTimer == 0 && KeyBind.ARMOR_CHARGING.isKeyDown(player)) {
            canShare = !canShare;
            toggleTimer = 5;
            if (!world.field_72995_K) {
                if (canShare && cont.getCharge() == 0L) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.qts.share.error", new Object[0]), true);
                } else if (canShare) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.qts.share.enable", new Object[0]), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.qts.share.disable", new Object[0]), true);
                }
            }
            canShare = canShare && cont.getCharge() != 0L;
            data.func_74757_a("canShare", canShare);
        }
        this.performFlying(player, hoverMode, item);
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
        if (canShare && !world.field_72995_K) {
            if (this.timer % 100L == 0L) {
                this.inventoryIndexMap = ArmorUtils.getChargeableItem(player, cont.getTier());
            }
            if (this.inventoryIndexMap != null && !this.inventoryIndexMap.isEmpty()) {
                for (int i = 0; i < this.inventoryIndexMap.size(); ++i) {
                    Pair<NonNullList<ItemStack>, List<Integer>> inventoryMap = this.inventoryIndexMap.get(i);
                    Iterator inventoryIterator = ((List)inventoryMap.getValue()).iterator();
                    while (inventoryIterator.hasNext()) {
                        int slot = (Integer)inventoryIterator.next();
                        IElectricItem chargable = (IElectricItem)((ItemStack)((NonNullList)inventoryMap.getKey()).get(slot)).getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
                        if (chargable == null || chargable == cont) {
                            inventoryIterator.remove();
                            continue;
                        }
                        long attemptedChargeAmount = chargable.getTransferLimit() * 10L;
                        if (chargable.getCharge() >= chargable.getMaxCharge() || !cont.canUse(attemptedChargeAmount) || this.timer % 10L != 0L) continue;
                        long delta = chargable.charge(attemptedChargeAmount, cont.getTier(), true, false);
                        if (delta > 0L) {
                            cont.discharge(delta, cont.getTier(), true, false, false);
                        }
                        if (chargable.getCharge() == chargable.getMaxCharge()) {
                            inventoryIterator.remove();
                        }
                        player.field_71069_bz.func_75142_b();
                    }
                    if (!((List)inventoryMap.getValue()).isEmpty()) continue;
                    this.inventoryIndexMap.remove(inventoryMap);
                }
            }
        }
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.func_74757_a("canShare", canShare);
        data.func_74757_a("hover", hoverMode);
        data.func_74774_a("toggleTimer", toggleTimer);
        player.field_71069_bz.func_75142_b();
        ++this.timer;
        if (this.timer == Long.MAX_VALUE) {
            this.timer = 0L;
        }
    }

    @Override
    public void addInfo(ItemStack itemStack, List<String> lines) {
        NBTTagCompound data = GTUtility.getOrCreateNbtCompound(itemStack);
        String state = data.func_74764_b("canShare") ? (data.func_74767_n("canShare") ? I18n.func_135052_a((String)"metaarmor.hud.status.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"metaarmor.hud.status.disabled", (Object[])new Object[0])) : I18n.func_135052_a((String)"metaarmor.hud.status.disabled", (Object[])new Object[0]);
        lines.add(I18n.func_135052_a((String)"metaarmor.energy_share.tooltip", (Object[])new Object[]{state}));
        lines.add(I18n.func_135052_a((String)"metaarmor.energy_share.tooltip.guide", (Object[])new Object[0]));
        String status = I18n.func_135052_a((String)"metaarmor.hud.status.disabled", (Object[])new Object[0]);
        if (data.func_74764_b("hover") && data.func_74767_n("hover")) {
            status = I18n.func_135052_a((String)"metaarmor.hud.status.enabled", (Object[])new Object[0]);
        }
        lines.add(I18n.func_135052_a((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{status}));
        super.addInfo(itemStack, lines);
    }

    @Override
    public ActionResult<ItemStack> onRightClick(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(hand).func_77973_b() instanceof ArmorMetaItem && player.func_70093_af()) {
            NBTTagCompound data = GTUtility.getOrCreateNbtCompound(player.func_184586_b(hand));
            boolean canShare = data.func_74764_b("canShare") && data.func_74767_n("canShare");
            IElectricItem cont = (IElectricItem)player.func_184586_b(hand).getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (cont == null) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
            }
            boolean bl = canShare = !canShare;
            if (!world.field_72995_K) {
                if (canShare && cont.getCharge() == 0L) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("metaarmor.energy_share.error", new Object[0]));
                } else if (canShare) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("metaarmor.energy_share.enable", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("metaarmor.energy_share.disable", new Object[0]));
                }
            }
            canShare = canShare && cont.getCharge() != 0L;
            data.func_74757_a("canShare", canShare);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return super.onRightClick(world, player, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isNeedDrawHUD() {
        return true;
    }

    @Override
    public void drawHUD(ItemStack item) {
        super.addCapacityHUD(item);
        IElectricItem cont = (IElectricItem)item.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (cont == null) {
            return;
        }
        if (!cont.canUse(this.energyPerUse)) {
            return;
        }
        NBTTagCompound data = item.func_77978_p();
        if (data != null) {
            String status;
            if (data.func_74764_b("canShare")) {
                status = data.func_74767_n("canShare") ? "metaarmor.hud.status.enabled" : "metaarmor.hud.status.disabled";
                this.HUD.newString(I18n.func_135052_a((String)"mataarmor.hud.supply_mode", (Object[])new Object[]{I18n.func_135052_a((String)status, (Object[])new Object[0])}));
            }
            if (data.func_74764_b("hover")) {
                status = data.func_74767_n("hover") ? "metaarmor.hud.status.enabled" : "metaarmor.hud.status.disabled";
                this.HUD.newString(I18n.func_135052_a((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{I18n.func_135052_a((String)status, (Object[])new Object[0])}));
            }
        }
        this.HUD.draw();
        this.HUD.reset();
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        int damageLimit = Integer.MAX_VALUE;
        IElectricItem item = (IElectricItem)armor.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item == null) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, damageLimit);
        }
        if (this.energyPerUse > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * (double)item.getCharge() / ((double)this.energyPerUse * 250.0));
        }
        return new ISpecialArmor.ArmorProperties(8, this.getDamageAbsorption() * (double)this.getAbsorption(armor), damageLimit);
    }

    @Override
    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        return source != DamageSource.field_76379_h && source != DamageSource.field_76369_e && source != DamageSource.field_76366_f;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "gregtech:textures/armor/advanced_quark_tech_suite_1.png";
    }

    @Override
    public double getDamageAbsorption() {
        return 1.5;
    }

    @Override
    public boolean canUseEnergy(@Nonnull ItemStack stack, int amount) {
        IElectricItem container = this.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.canUse(amount);
    }

    @Override
    public void drainEnergy(@Nonnull ItemStack stack, int amount) {
        IElectricItem container = this.getIElectricItem(stack);
        if (container == null) {
            return;
        }
        container.discharge(amount, this.tier, true, false, false);
    }

    @Override
    public boolean hasEnergy(@Nonnull ItemStack stack) {
        IElectricItem container = this.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.getCharge() > 0L;
    }

    private IElectricItem getIElectricItem(@Nonnull ItemStack stack) {
        return (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
    }

    @Override
    public double getSprintEnergyModifier() {
        return 6.0;
    }

    @Override
    public double getSprintSpeedModifier() {
        return 2.4;
    }

    @Override
    public double getVerticalHoverSpeed() {
        return 0.45;
    }

    @Override
    public double getVerticalHoverSlowSpeed() {
        return 0.0;
    }

    @Override
    public double getVerticalAcceleration() {
        return 0.15;
    }

    @Override
    public double getVerticalSpeed() {
        return 0.9;
    }

    @Override
    public double getSidewaysSpeed() {
        return 0.21;
    }

    @Override
    public EnumParticleTypes getParticle() {
        return null;
    }

    @Override
    public float getFallDamageReduction() {
        return 8.0f;
    }
}

