/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.ISubItemHandler;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.hardware.Hardware;
import gregtech.api.terminal.hardware.HardwareProvider;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.common.terminal.hardware.BatteryHardware;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TerminalBehaviour
implements IItemBehaviour,
ItemUIFactory,
ISubItemHandler {
    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player.func_70093_af()) {
            ItemStack itemStack = player.func_184586_b(hand);
            itemStack.func_190925_c("terminal").func_82580_o("_click");
            if (pos != null) {
                itemStack.func_190925_c("terminal").func_74782_a("_click", (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
                if (!world.field_72995_K) {
                    PlayerInventoryHolder holder = new PlayerInventoryHolder(player, hand);
                    holder.openUI();
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        itemStack.func_190925_c("terminal").func_82580_o("_click");
        if (!world.field_72995_K) {
            PlayerInventoryHolder holder = new PlayerInventoryHolder(player, hand);
            holder.openUI();
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @Override
    public void onUpdate(ItemStack itemStack, Entity entity) {
        NBTTagCompound tabletNBT = itemStack.func_190925_c("terminal");
        if (tabletNBT.func_74764_b("_ar")) {
            String appName = tabletNBT.func_74779_i("_ar");
            int tier = TerminalRegistry.getApplication(appName).getMaxTier();
            if (!TerminalBehaviour.isCreative(itemStack)) {
                tier = Math.min(tabletNBT.func_74775_l(appName).func_74762_e("_tier"), tier);
            }
            long cost = 0L;
            for (Hardware hardware : TerminalRegistry.getAppHardwareDemand(appName, tier)) {
                if (!(hardware instanceof BatteryHardware)) continue;
                cost = ((BatteryHardware)hardware).getCharge();
                break;
            }
            if (cost > 0L) {
                IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
                if (electricItem != null) {
                    long back = electricItem.discharge(cost, 999, true, false, false);
                    if (back != cost) {
                        tabletNBT.func_82580_o("_ar");
                    }
                } else {
                    tabletNBT.func_82580_o("_ar");
                }
            }
        }
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        HardwareProvider provider = (HardwareProvider)itemStack.getCapability(GregtechCapabilities.CAPABILITY_HARDWARE_PROVIDER, null);
        if (TerminalBehaviour.isCreative(itemStack)) {
            lines.add(I18n.func_135052_a((String)"metaitem.terminal.tooltip.creative", (Object[])new Object[0]));
        }
        if (provider != null) {
            List<Hardware> hardware = provider.getHardware();
            lines.add(I18n.func_135052_a((String)"metaitem.terminal.tooltip.hardware", (Object[])new Object[]{hardware.size()}));
            for (Hardware hw : hardware) {
                String info = hw.addInformation();
                if (info == null) {
                    lines.add(hw.getLocalizedName());
                    continue;
                }
                lines.add(String.format("%s (%s)", hw.getLocalizedName(), info));
            }
        }
    }

    @Override
    public ModularUI createUI(PlayerInventoryHolder holder, EntityPlayer entityPlayer) {
        return ModularUI.builder(IGuiTexture.EMPTY, 380, 256).widget(new TerminalOSWidget(12, 11, holder.getCurrentItem())).shouldColor(false).build(holder, entityPlayer);
    }

    public static boolean isCreative(ItemStack itemStack) {
        return itemStack != null && itemStack.func_190925_c("terminal").func_74767_n("_creative");
    }

    @Override
    public String getItemSubType(ItemStack itemStack) {
        return "";
    }

    @Override
    public void getSubItems(ItemStack itemStack, CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        ItemStack copy = itemStack.func_77946_l();
        copy.func_190925_c("terminal").func_74757_a("_creative", true);
        subItems.add((Object)copy);
    }
}

