/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.tool;

import com.google.common.collect.ImmutableSet;
import gregtech.api.GTValues;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.items.toolitem.aoe.AoESymmetrical;
import gregtech.api.items.toolitem.behavior.IToolBehavior;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HarvestCropsBehavior
implements IToolBehavior {
    public static final HarvestCropsBehavior INSTANCE = new HarvestCropsBehavior();

    protected HarvestCropsBehavior() {
    }

    @Override
    @Nonnull
    public EnumActionResult onItemUse(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Object blocks;
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (aoeDefinition == AoESymmetrical.none()) {
            blocks = ImmutableSet.of((Object)pos);
        } else {
            RayTraceResult rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
            if (rayTraceResult == null) {
                return EnumActionResult.PASS;
            }
            if (rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                return EnumActionResult.PASS;
            }
            if (rayTraceResult.field_178784_b == null) {
                return EnumActionResult.PASS;
            }
            blocks = ToolHelper.iterateAoE(stack, aoeDefinition, player.field_70170_p, player, rayTraceResult, HarvestCropsBehavior::isBlockCrops);
            if (HarvestCropsBehavior.isBlockCrops(stack, world, player, rayTraceResult.func_178782_a(), null)) {
                blocks.add(rayTraceResult.func_178782_a());
            }
        }
        boolean harvested = false;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = (BlockPos)iterator.next();
            if (!HarvestCropsBehavior.harvestBlockRoutine(stack, blockPos, player)) continue;
            harvested = true;
        }
        return harvested ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    private static boolean isBlockCrops(ItemStack stack, World world, EntityPlayer player, BlockPos pos, @Nullable BlockPos hitBlockPos) {
        if (world.func_175623_d(pos.func_177984_a())) {
            Block block = world.func_180495_p(pos).func_177230_c();
            return block instanceof BlockCrops;
        }
        return false;
    }

    private static boolean harvestBlockRoutine(ItemStack stack, BlockPos pos, EntityPlayer player) {
        IBlockState blockState = player.field_70170_p.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        BlockCrops blockCrops = (BlockCrops)block;
        if (blockCrops.func_185525_y(blockState)) {
            NonNullList drops = NonNullList.func_191196_a();
            blockCrops.getDrops(drops, (IBlockAccess)player.field_70170_p, pos, blockState, 0);
            HarvestCropsBehavior.dropListOfItems(player.field_70170_p, pos, (List<ItemStack>)drops);
            player.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockState));
            player.field_70170_p.func_175656_a(pos, blockCrops.func_185528_e(0));
            if (!player.func_184812_l_()) {
                ToolHelper.damageItem(stack, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    private static void dropListOfItems(World world, BlockPos pos, List<ItemStack> drops) {
        for (ItemStack stack : drops) {
            float f = 0.7f;
            double offX = (double)(GTValues.RNG.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offY = (double)(GTValues.RNG.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offZ = (double)(GTValues.RNG.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + offX, (double)pos.func_177956_o() + offY, (double)pos.func_177952_p() + offZ, stack);
            entityItem.func_174869_p();
            world.func_72838_d((Entity)entityItem);
        }
    }

    @Override
    public void addInformation(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"item.gt.tool.behavior.crop_harvesting", (Object[])new Object[0]));
    }
}

