/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.converter;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.FeCompat;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.PipelineUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.converter.ConverterTrait;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityConverter
extends TieredMetaTileEntity {
    protected final ConverterTrait converterTrait;
    protected final int amps;

    public MetaTileEntityConverter(ResourceLocation metaTileEntityId, int tier, int amps) {
        super(metaTileEntityId, tier);
        this.amps = amps;
        this.converterTrait = this.initializeTrait();
        this.reinitializeEnergyContainer();
    }

    protected ConverterTrait initializeTrait() {
        return new ConverterTrait(this, this.amps, true);
    }

    @Override
    protected void reinitializeEnergyContainer() {
        if (this.converterTrait == null) {
            return;
        }
        this.energyContainer = this.converterTrait.getEnergyEUContainer();
    }

    @Override
    public boolean onSoftMalletClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.getWorld().field_72995_K) {
            this.scheduleRenderUpdate();
            return true;
        }
        if (this.converterTrait.isFeToEu()) {
            this.setFeToEu(false);
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.energy_converter.message_conversion_eu", new Object[]{this.converterTrait.getBaseAmps(), this.converterTrait.getVoltage(), FeCompat.toFe(this.converterTrait.getVoltage() * (long)this.converterTrait.getBaseAmps(), FeCompat.ratio(false))}));
        } else {
            this.setFeToEu(true);
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.energy_converter.message_conversion_fe", new Object[]{FeCompat.toFe(this.converterTrait.getVoltage() * (long)this.converterTrait.getBaseAmps(), FeCompat.ratio(true)), this.converterTrait.getBaseAmps(), this.converterTrait.getVoltage()}));
        }
        return true;
    }

    public void setFeToEu(boolean feToEu) {
        this.converterTrait.setFeToEu(feToEu);
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(500, b -> b.writeBoolean(this.converterTrait.isFeToEu()));
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    public boolean isFeToEu() {
        return this.converterTrait.isFeToEu();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == 500) {
            this.converterTrait.setFeToEu(buf.readBoolean());
            this.scheduleRenderUpdate();
        }
        super.receiveCustomData(dataId, buf);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityConverter(this.metaTileEntityId, this.getTier(), this.amps);
    }

    @Override
    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        if (ConfigHolder.compat.energy.enableFEConverters) {
            super.getSubItems(creativeTab, subItems);
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        buf.writeBoolean(this.converterTrait.isFeToEu());
        super.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        this.converterTrait.setFeToEu(buf.readBoolean());
        super.receiveInitialSyncData(buf);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        Textures.VOLTAGE_CASINGS[this.getTier()].render(renderState, translation, colouredPipeline);
        if (this.converterTrait.isFeToEu()) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (facing == this.frontFacing) {
                    Textures.ENERGY_OUT.renderSided(facing, renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()]));
                    continue;
                }
                Textures.CONVERTER_FE_IN.renderSided(facing, renderState, translation, pipeline);
            }
        } else {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (facing == this.frontFacing) {
                    Textures.CONVERTER_FE_OUT.renderSided(facing, renderState, translation, pipeline);
                    continue;
                }
                Textures.ENERGY_IN.renderSided(facing, renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()]));
            }
        }
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[this.getTier()].getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return (T)(this.converterTrait.isFeToEu() == (side == this.frontFacing) ? GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)this.converterTrait.getEnergyEUContainer()) : null);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)(side != (this.converterTrait.isFeToEu() ? this.frontFacing : null) ? CapabilityEnergy.ENERGY.cast((Object)this.converterTrait.getEnergyFEContainer()) : null);
        }
        if (capability == GregtechCapabilities.CAPABILITY_CONVERTER) {
            return (T)GregtechCapabilities.CAPABILITY_CONVERTER.cast((Object)this.converterTrait);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return true;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        long voltage = this.converterTrait.getVoltage();
        long amps = this.converterTrait.getBaseAmps();
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_converter.description", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_converter.tooltip_tool_usage", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_converter.tooltip_conversion_fe", (Object[])new Object[]{FeCompat.toFe(voltage * amps, FeCompat.ratio(true)), amps, voltage, GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_converter.tooltip_conversion_eu", (Object[])new Object[]{amps, voltage, GTValues.VNF[this.getTier()], FeCompat.toFe(voltage * amps, FeCompat.ratio(false))}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.toggle_mode", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    protected long getMaxInputOutputAmperage() {
        return this.converterTrait.getBaseAmps();
    }

    @Override
    protected boolean isEnergyEmitter() {
        return this.converterTrait.isFeToEu();
    }
}

