/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.texture.Textures;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SteamMacerator
extends SteamMetaTileEntity {
    public SteamMacerator(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, RecipeMaps.MACERATOR_RECIPES, Textures.MACERATOR_OVERLAY, isHighPressure);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SteamMacerator(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler(1, this, false);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new NotifiableItemStackHandler(1, this, true);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        return this.createUITemplate(player).slot(this.importItems, 0, 53, 25, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.CRUSHED_ORE_OVERLAY_STEAM.get(this.isHighPressure)).progressBar(this.workableHandler::getProgressPercent, 79, 26, 21, 18, GuiTextures.PROGRESS_BAR_MACERATE_STEAM.get(this.isHighPressure), ProgressWidget.MoveType.HORIZONTAL, this.workableHandler.getRecipeMap()).slot(this.exportItems, 0, 107, 25, true, false, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.DUST_OVERLAY_STEAM.get(this.isHighPressure)).build(this.getHolder(), player);
    }

    @Override
    public int getItemOutputLimit() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.isActive()) {
            BlockPos pos = this.getPos();
            float horizontalOffset = GTValues.RNG.nextFloat() * 0.6f - 0.3f;
            this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + horizontalOffset), (double)((float)pos.func_177956_o() + 0.52f), (double)((float)pos.func_177952_p() + horizontalOffset), (double)(GTValues.RNG.nextFloat() * 0.125f), (double)(GTValues.RNG.nextFloat() * 0.375f), (double)(GTValues.RNG.nextFloat() * 0.125f), new int[0]);
        }
    }
}

